/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CFHeaderBase;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.common.FtrHeader;
import ai2.org.apache.poi.hssf.record.common.FutureRecord;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class CFHeader12Record
extends CFHeaderBase
implements FutureRecord {
    public static final short sid = 2169;
    private FtrHeader futureHeader;

    public CFHeader12Record() {
        this.createEmpty();
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2169);
    }

    public CFHeader12Record(CellRangeAddress[] cellRangeAddressArray, int n) {
        super(cellRangeAddressArray, n);
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2169);
    }

    public CFHeader12Record(RecordInputStream recordInputStream) {
        this.futureHeader = new FtrHeader(recordInputStream);
        this.read(recordInputStream);
    }

    protected String getRecordName() {
        return "CFHEADER12";
    }

    protected int getDataSize() {
        return FtrHeader.getDataSize() + super.getDataSize();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        this.futureHeader.setAssociatedRange(this.getEnclosingCellRange());
        this.futureHeader.serialize(littleEndianOutput);
        super.serialize(littleEndianOutput);
    }

    public short getSid() {
        return 2169;
    }

    public short getFutureRecordType() {
        return this.futureHeader.getRecordType();
    }

    public FtrHeader getFutureHeader() {
        return this.futureHeader;
    }

    public CellRangeAddress getAssociatedRange() {
        return this.futureHeader.getAssociatedRange();
    }

    public Object clone() {
        CFHeader12Record cFHeader12Record = new CFHeader12Record();
        cFHeader12Record.futureHeader = (FtrHeader)this.futureHeader.clone();
        super.copyTo(cFHeader12Record);
        return cFHeader12Record;
    }
}

