/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.ss.util.WorkbookUtil;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoundSheetRecord
extends StandardRecord {
    public static final short sid = 133;
    private static final BitField hiddenFlag = BitFieldFactory.getInstance(1);
    private static final BitField veryHiddenFlag = BitFieldFactory.getInstance(2);
    private int field_1_position_of_BOF;
    private int field_2_option_flags;
    private int field_4_isMultibyteUnicode;
    private String field_5_sheetname;
    private static final Comparator<BoundSheetRecord> BOFComparator = new Comparator<BoundSheetRecord>(){

        @Override
        public int compare(BoundSheetRecord boundSheetRecord, BoundSheetRecord boundSheetRecord2) {
            return boundSheetRecord.getPositionOfBof() - boundSheetRecord2.getPositionOfBof();
        }
    };

    public BoundSheetRecord(String string) {
        this.field_2_option_flags = 0;
        this.setSheetname(string);
    }

    public BoundSheetRecord(RecordInputStream recordInputStream) {
        this.field_1_position_of_BOF = recordInputStream.readInt();
        this.field_2_option_flags = recordInputStream.readUShort();
        int n = recordInputStream.readUByte();
        this.field_4_isMultibyteUnicode = recordInputStream.readByte();
        this.field_5_sheetname = this.isMultibyte() ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    public void setPositionOfBof(int n) {
        this.field_1_position_of_BOF = n;
    }

    public void setSheetname(String string) {
        WorkbookUtil.validateSheetName(string);
        this.field_5_sheetname = string;
        this.field_4_isMultibyteUnicode = StringUtil.hasMultibyte(string) ? 1 : 0;
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    private boolean isMultibyte() {
        return (this.field_4_isMultibyteUnicode & 1) != 0;
    }

    public String getSheetname() {
        return this.field_5_sheetname;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOUNDSHEET]\n");
        stringBuffer.append("    .bof        = ").append(HexDump.intToHex(this.getPositionOfBof())).append("\n");
        stringBuffer.append("    .options    = ").append(HexDump.shortToHex(this.field_2_option_flags)).append("\n");
        stringBuffer.append("    .unicodeflag= ").append(HexDump.byteToHex(this.field_4_isMultibyteUnicode)).append("\n");
        stringBuffer.append("    .sheetname  = ").append(this.field_5_sheetname).append("\n");
        stringBuffer.append("[/BOUNDSHEET]\n");
        return stringBuffer.toString();
    }

    @Override
    protected int getDataSize() {
        return 8 + this.field_5_sheetname.length() * (this.isMultibyte() ? 2 : 1);
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.getPositionOfBof());
        littleEndianOutput.writeShort(this.field_2_option_flags);
        String string = this.field_5_sheetname;
        littleEndianOutput.writeByte(string.length());
        littleEndianOutput.writeByte(this.field_4_isMultibyteUnicode);
        if (this.isMultibyte()) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    @Override
    public short getSid() {
        return 133;
    }

    public boolean isHidden() {
        return hiddenFlag.isSet(this.field_2_option_flags);
    }

    public void setHidden(boolean bl) {
        this.field_2_option_flags = hiddenFlag.setBoolean(this.field_2_option_flags, bl);
    }

    public boolean isVeryHidden() {
        return veryHiddenFlag.isSet(this.field_2_option_flags);
    }

    public void setVeryHidden(boolean bl) {
        this.field_2_option_flags = veryHiddenFlag.setBoolean(this.field_2_option_flags, bl);
    }

    public static BoundSheetRecord[] orderByBofPosition(List<BoundSheetRecord> list) {
        BoundSheetRecord[] boundSheetRecordArray = new BoundSheetRecord[list.size()];
        list.toArray(boundSheetRecordArray);
        Arrays.sort(boundSheetRecordArray, BOFComparator);
        return boundSheetRecordArray;
    }
}

