/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record;

import ai2.org.apache.poi.hssf.record.CellRecord;
import ai2.org.apache.poi.hssf.record.RecordFormatException;
import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.ss.usermodel.ErrorConstants;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class BoolErrRecord
extends CellRecord {
    public static final short sid = 517;
    private int _value;
    private boolean _isError;

    public BoolErrRecord() {
    }

    public BoolErrRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        switch (recordInputStream.remaining()) {
            case 2: {
                this._value = recordInputStream.readByte();
                break;
            }
            case 3: {
                this._value = recordInputStream.readUShort();
                break;
            }
            default: {
                throw new RecordFormatException("Unexpected size (" + recordInputStream.remaining() + ") for BOOLERR record.");
            }
        }
        int n = recordInputStream.readUByte();
        switch (n) {
            case 0: {
                this._isError = false;
                break;
            }
            case 1: {
                this._isError = true;
                break;
            }
            default: {
                throw new RecordFormatException("Unexpected isError flag (" + n + ") for BOOLERR record.");
            }
        }
    }

    public void setValue(boolean bl) {
        this._value = bl ? 1 : 0;
        this._isError = false;
    }

    public void setValue(byte by) {
        switch (by) {
            case 0: 
            case 7: 
            case 15: 
            case 23: 
            case 29: 
            case 36: 
            case 42: {
                this._value = by;
                this._isError = true;
                return;
            }
        }
        throw new IllegalArgumentException("Error Value can only be 0,7,15,23,29,36 or 42. It cannot be " + by);
    }

    public boolean getBooleanValue() {
        return this._value != 0;
    }

    public byte getErrorValue() {
        return (byte)this._value;
    }

    public boolean isBoolean() {
        return !this._isError;
    }

    public boolean isError() {
        return this._isError;
    }

    protected String getRecordName() {
        return "BOOLERR";
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        if (this.isBoolean()) {
            stringBuilder.append("  .boolVal = ");
            stringBuilder.append(this.getBooleanValue());
        } else {
            stringBuilder.append("  .errCode = ");
            stringBuilder.append(ErrorConstants.getText(this.getErrorValue()));
            stringBuilder.append(" (").append(HexDump.byteToHex(this.getErrorValue())).append(")");
        }
    }

    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this._value);
        littleEndianOutput.writeByte(this._isError ? 1 : 0);
    }

    protected int getValueDataSize() {
        return 2;
    }

    public short getSid() {
        return 517;
    }

    public Object clone() {
        BoolErrRecord boolErrRecord = new BoolErrRecord();
        this.copyBaseFields(boolErrRecord);
        boolErrRecord._value = this._value;
        boolErrRecord._isError = this._isError;
        return boolErrRecord;
    }
}

