/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.model;

import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import java.util.ArrayList;
import java.util.List;

public class DrawingManager2 {
    EscherDggRecord dgg;
    List<EscherDgRecord> drawingGroups = new ArrayList<EscherDgRecord>();

    public DrawingManager2(EscherDggRecord escherDggRecord) {
        this.dgg = escherDggRecord;
    }

    public void clearDrawingGroups() {
        this.drawingGroups.clear();
    }

    public EscherDgRecord createDgRecord() {
        EscherDgRecord escherDgRecord = new EscherDgRecord();
        escherDgRecord.setRecordId((short)-4088);
        short s = this.findNewDrawingGroupId();
        escherDgRecord.setOptions((short)(s << 4));
        escherDgRecord.setNumShapes(0);
        escherDgRecord.setLastMSOSPID(-1);
        this.drawingGroups.add(escherDgRecord);
        this.dgg.addCluster(s, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        return escherDgRecord;
    }

    public int allocateShapeId(short s) {
        EscherDgRecord escherDgRecord = this.getDrawingGroup(s);
        return this.allocateShapeId(s, escherDgRecord);
    }

    public int allocateShapeId(short s, EscherDgRecord escherDgRecord) {
        int n;
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        for (n = 0; n < this.dgg.getFileIdClusters().length; ++n) {
            EscherDggRecord.FileIdCluster fileIdCluster = this.dgg.getFileIdClusters()[n];
            if (fileIdCluster.getDrawingGroupId() != s || fileIdCluster.getNumShapeIdsUsed() == 1024) continue;
            int n2 = fileIdCluster.getNumShapeIdsUsed() + 1024 * (n + 1);
            fileIdCluster.incrementShapeId();
            escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
            escherDgRecord.setLastMSOSPID(n2);
            if (n2 >= this.dgg.getShapeIdMax()) {
                this.dgg.setShapeIdMax(n2 + 1);
            }
            return n2;
        }
        this.dgg.addCluster(s, 0);
        this.dgg.getFileIdClusters()[this.dgg.getFileIdClusters().length - 1].incrementShapeId();
        escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
        n = 1024 * this.dgg.getFileIdClusters().length;
        escherDgRecord.setLastMSOSPID(n);
        if (n >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(n + 1);
        }
        return n;
    }

    public short findNewDrawingGroupId() {
        short s = 1;
        while (this.drawingGroupExists(s)) {
            s = (short)(s + 1);
        }
        return s;
    }

    EscherDgRecord getDrawingGroup(int n) {
        return this.drawingGroups.get(n - 1);
    }

    boolean drawingGroupExists(short s) {
        for (int i = 0; i < this.dgg.getFileIdClusters().length; ++i) {
            if (this.dgg.getFileIdClusters()[i].getDrawingGroupId() != s) continue;
            return true;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int n = this.dgg.getShapeIdMax();
        int n2 = (n / 1024 + 1) * 1024;
        return n2;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }

    public void incrementDrawingsSaved() {
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
    }
}

