/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.model;

import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import java.util.HashMap;
import java.util.Map;

public class DrawingManager {
    EscherDggRecord dgg;
    Map<Short, EscherDgRecord> dgMap = new HashMap<Short, EscherDgRecord>();

    public DrawingManager(EscherDggRecord escherDggRecord) {
        this.dgg = escherDggRecord;
    }

    public EscherDgRecord createDgRecord() {
        EscherDgRecord escherDgRecord = new EscherDgRecord();
        escherDgRecord.setRecordId((short)-4088);
        short s = this.findNewDrawingGroupId();
        escherDgRecord.setOptions((short)(s << 4));
        escherDgRecord.setNumShapes(0);
        escherDgRecord.setLastMSOSPID(-1);
        this.dgg.addCluster(s, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        this.dgMap.put(s, escherDgRecord);
        return escherDgRecord;
    }

    public int allocateShapeId(short s) {
        EscherDgRecord escherDgRecord = this.dgMap.get(s);
        int n = escherDgRecord.getLastMSOSPID();
        int n2 = 0;
        if (n % 1024 == 1023) {
            n2 = this.findFreeSPIDBlock();
            this.dgg.addCluster(s, 1);
        } else {
            for (int i = 0; i < this.dgg.getFileIdClusters().length; ++i) {
                EscherDggRecord.FileIdCluster fileIdCluster = this.dgg.getFileIdClusters()[i];
                if (fileIdCluster.getDrawingGroupId() == s && fileIdCluster.getNumShapeIdsUsed() != 1024) {
                    fileIdCluster.incrementShapeId();
                }
                n2 = escherDgRecord.getLastMSOSPID() == -1 ? this.findFreeSPIDBlock() : escherDgRecord.getLastMSOSPID() + 1;
            }
        }
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        if (n2 >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(n2 + 1);
        }
        escherDgRecord.setLastMSOSPID(n2);
        escherDgRecord.incrementShapeCount();
        return n2;
    }

    short findNewDrawingGroupId() {
        short s = 1;
        while (this.drawingGroupExists(s)) {
            s = (short)(s + 1);
        }
        return s;
    }

    boolean drawingGroupExists(short s) {
        for (int i = 0; i < this.dgg.getFileIdClusters().length; ++i) {
            if (this.dgg.getFileIdClusters()[i].getDrawingGroupId() != s) continue;
            return true;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int n = this.dgg.getShapeIdMax();
        int n2 = (n / 1024 + 1) * 1024;
        return n2;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }
}

