/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.eventusermodel;

import ai2.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import ai2.org.apache.poi.hssf.eventusermodel.HSSFUserException;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.hssf.record.RecordFactoryInputStream;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest hSSFRequest, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this.processWorkbookEvents(hSSFRequest, pOIFSFileSystem.getRoot());
    }

    public void processWorkbookEvents(HSSFRequest hSSFRequest, DirectoryNode directoryNode) throws IOException {
        Set<String> set = directoryNode.getEntryNames();
        String string = set.contains("Workbook") ? "Workbook" : (set.contains("WORKBOOK") ? "WORKBOOK" : (set.contains("BOOK") ? "BOOK" : "Workbook"));
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(string);
        this.processEvents(hSSFRequest, documentInputStream);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest hSSFRequest, POIFSFileSystem pOIFSFileSystem) throws IOException, HSSFUserException {
        return this.abortableProcessWorkbookEvents(hSSFRequest, pOIFSFileSystem.getRoot());
    }

    public short abortableProcessWorkbookEvents(HSSFRequest hSSFRequest, DirectoryNode directoryNode) throws IOException, HSSFUserException {
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(hSSFRequest, documentInputStream);
    }

    public void processEvents(HSSFRequest hSSFRequest, InputStream inputStream) {
        try {
            this.genericProcessEvents(hSSFRequest, inputStream);
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest hSSFRequest, InputStream inputStream) throws HSSFUserException {
        return this.genericProcessEvents(hSSFRequest, inputStream);
    }

    private short genericProcessEvents(HSSFRequest hSSFRequest, InputStream inputStream) throws HSSFUserException {
        Record record;
        short s = 0;
        RecordFactoryInputStream recordFactoryInputStream = new RecordFactoryInputStream(inputStream, false);
        while ((record = recordFactoryInputStream.nextRecord()) != null && (s = hSSFRequest.processRecord(record)) == 0) {
        }
        return s;
    }
}

