/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.dev;

import ai2.org.apache.poi.hssf.dev.BiffViewer;
import ai2.org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import ai2.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai2.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import ai2.org.apache.poi.hssf.record.Record;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class EFBiffViewer {
    String file;

    public void run() throws IOException {
        NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(new File(this.file), true);
        InputStream inputStream = BiffViewer.getPOIFSInputStream(nPOIFSFileSystem);
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords(new HSSFListener(){

            public void processRecord(Record record) {
                System.out.println(record.toString());
            }
        });
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        hSSFEventFactory.processEvents(hSSFRequest, inputStream);
        inputStream.close();
        nPOIFSFileSystem.close();
    }

    public void setFile(String string) {
        this.file = string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && !stringArray[0].equals("--help")) {
            try {
                EFBiffViewer eFBiffViewer = new EFBiffViewer();
                eFBiffViewer.setFile(stringArray[0]);
                eFBiffViewer.run();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("EFBiffViewer");
            System.out.println("Outputs biffview of records based on HSSFEventFactory");
            System.out.println("usage: java ai2.org.apache.poi.hssf.dev.EBBiffViewer filename");
        }
    }
}

