/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.converter;

import ai2.org.apache.poi.hssf.converter.AbstractExcelUtils;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import java.util.Arrays;

public class ExcelToHtmlUtils
extends AbstractExcelUtils {
    public static void appendAlign(StringBuilder stringBuilder, short s) {
        String string = ExcelToHtmlUtils.getAlign(s);
        if (ExcelToHtmlUtils.isEmpty(string)) {
            return;
        }
        stringBuilder.append("text-align:");
        stringBuilder.append(string);
        stringBuilder.append(";");
    }

    public static CellRangeAddress[][] buildMergedRangesMap(HSSFSheet hSSFSheet) {
        CellRangeAddress[][] cellRangeAddressArray = new CellRangeAddress[1][];
        for (int i = 0; i < hSSFSheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = hSSFSheet.getMergedRegion(i);
            int n = cellRangeAddress.getLastRow() + 1;
            if (cellRangeAddressArray.length < n) {
                CellRangeAddress[][] cellRangeAddressArrayArray = new CellRangeAddress[n][];
                System.arraycopy(cellRangeAddressArray, 0, cellRangeAddressArrayArray, 0, cellRangeAddressArray.length);
                cellRangeAddressArray = cellRangeAddressArrayArray;
            }
            for (int j = cellRangeAddress.getFirstRow(); j <= cellRangeAddress.getLastRow(); ++j) {
                int n2 = cellRangeAddress.getLastColumn() + 1;
                Object[] objectArray = cellRangeAddressArray[j];
                if (objectArray == null) {
                    objectArray = new CellRangeAddress[n2];
                    cellRangeAddressArray[j] = objectArray;
                } else {
                    int n3 = objectArray.length;
                    if (n3 < n2) {
                        CellRangeAddress[] cellRangeAddressArray2 = new CellRangeAddress[n2];
                        System.arraycopy(objectArray, 0, cellRangeAddressArray2, 0, n3);
                        cellRangeAddressArray[j] = cellRangeAddressArray2;
                        objectArray = cellRangeAddressArray2;
                    }
                }
                Arrays.fill(objectArray, cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn() + 1, cellRangeAddress);
            }
        }
        return cellRangeAddressArray;
    }
}

