/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hssf.converter.AbstractExcelConverter;
import ai2.org.apache.poi.hssf.converter.ExcelToFoUtils;
import ai2.org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import ai2.org.apache.poi.hssf.converter.ExcelToHtmlUtils;
import ai2.org.apache.poi.hssf.usermodel.HSSFCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai2.org.apache.poi.hssf.usermodel.HSSFFont;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFRow;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.hwpf.converter.FoDocumentFacade;
import ai2.org.apache.poi.hwpf.converter.FontReplacer;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import ai2.org.apache.poi.ss.usermodel.CellStyle;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ExcelToFoConverter
extends AbstractExcelConverter {
    private static final float CM_PER_INCH = 2.54f;
    private static final float DPI = 72.0f;
    private static final POILogger logger = POILogFactory.getLogger(ExcelToFoConverter.class);
    private static final float PAPER_A4_HEIGHT_INCHES = 11.574803f;
    private static final float PAPER_A4_WIDTH_INCHES = 8.267716f;
    private final FoDocumentFacade foDocumentFacade;
    private float pageMarginInches = 0.4f;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: ExcelToFoConverter <inputFile.xls> <saveTo.xml>");
            return;
        }
        System.out.println("Converting " + stringArray[0]);
        System.out.println("Saving output to " + stringArray[1]);
        Document document = ExcelToHtmlConverter.process(new File(stringArray[0]));
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(stringArray[1]));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(dOMSource, streamResult);
    }

    public static Document process(File file) throws Exception {
        HSSFWorkbook hSSFWorkbook = ExcelToFoUtils.loadXls(file);
        ExcelToFoConverter excelToFoConverter = new ExcelToFoConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        excelToFoConverter.processWorkbook(hSSFWorkbook);
        Document document = excelToFoConverter.getDocument();
        hSSFWorkbook.close();
        return document;
    }

    public ExcelToFoConverter(Document document) {
        this.foDocumentFacade = new FoDocumentFacade(document);
    }

    public ExcelToFoConverter(FoDocumentFacade foDocumentFacade) {
        this.foDocumentFacade = foDocumentFacade;
    }

    protected String createPageMaster(float f, String string) {
        float f2;
        float f3;
        float f4 = f + 2.0f * this.getPageMarginInches();
        if (f4 < 8.267716f) {
            f3 = 8.267716f;
            f2 = 11.574803f;
        } else {
            f3 = f4;
            f2 = f3 * 0.7142857f;
        }
        f4 = this.getPageMarginInches();
        float f5 = this.getPageMarginInches();
        float f6 = this.getPageMarginInches();
        float f7 = this.getPageMarginInches();
        Element element = this.foDocumentFacade.addSimplePageMaster(string);
        element.setAttribute("page-height", f2 + "in");
        element.setAttribute("page-width", f3 + "in");
        Element element2 = this.foDocumentFacade.addRegionBody(element);
        element2.setAttribute("margin", f6 + "in " + f5 + "in " + f7 + "in " + f4 + "in");
        return string;
    }

    protected Document getDocument() {
        return this.foDocumentFacade.getDocument();
    }

    public float getPageMarginInches() {
        return this.pageMarginInches;
    }

    protected boolean isEmptyStyle(CellStyle cellStyle) {
        return cellStyle.getFillPattern() == 0 && cellStyle.getBorderTop() == 0 && cellStyle.getBorderRight() == 0 && cellStyle.getBorderBottom() == 0 && cellStyle.getBorderLeft() == 0;
    }

    protected boolean processCell(HSSFWorkbook hSSFWorkbook, HSSFCell hSSFCell, Element element, int n, int n2, float f) {
        Object object;
        String string;
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        block0 : switch (hSSFCell.getCellType()) {
            case 1: {
                string = hSSFCell.getRichStringCellValue().getString();
                break;
            }
            case 2: {
                switch (hSSFCell.getCachedFormulaResultType()) {
                    case 1: {
                        HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                        if (hSSFRichTextString != null && hSSFRichTextString.length() > 0) {
                            string = hSSFRichTextString.toString();
                            break block0;
                        }
                        string = "";
                        break block0;
                    }
                    case 0: {
                        HSSFCellStyle hSSFCellStyle2 = hSSFCellStyle;
                        if (hSSFCellStyle2 == null) {
                            string = String.valueOf(hSSFCell.getNumericCellValue());
                            break block0;
                        }
                        string = this._formatter.formatRawCellContents(hSSFCell.getNumericCellValue(), hSSFCellStyle2.getDataFormat(), hSSFCellStyle2.getDataFormatString());
                        break block0;
                    }
                    case 4: {
                        string = String.valueOf(hSSFCell.getBooleanCellValue());
                        break block0;
                    }
                    case 5: {
                        string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                        break block0;
                    }
                }
                logger.log(5, new Object[]{"Unexpected cell cachedFormulaResultType (" + hSSFCell.getCachedFormulaResultType() + ")"});
                string = "";
                break;
            }
            case 3: {
                string = "";
                break;
            }
            case 0: {
                string = this._formatter.formatCellValue(hSSFCell);
                break;
            }
            case 4: {
                string = String.valueOf(hSSFCell.getBooleanCellValue());
                break;
            }
            case 5: {
                string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                break;
            }
            default: {
                logger.log(5, new Object[]{"Unexpected cell type (" + hSSFCell.getCellType() + ")"});
                return true;
            }
        }
        boolean bl = ExcelToHtmlUtils.isEmpty(string);
        boolean bl2 = !bl && !hSSFCellStyle.getWrapText();
        boolean bl3 = this.isEmptyStyle(hSSFCellStyle);
        if (!bl3 && bl) {
            string = "\u00a0";
        }
        if (this.isOutputLeadingSpacesAsNonBreaking() && string.startsWith(" ")) {
            object = new StringBuilder();
            for (int i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
                ((StringBuilder)object).append('\u00a0');
            }
            if (string.length() != ((StringBuilder)object).length()) {
                ((StringBuilder)object).append(string.substring(((StringBuilder)object).length()));
            }
            string = ((StringBuilder)object).toString();
        }
        object = this.foDocumentFacade.createText(string);
        Element element2 = this.foDocumentFacade.createBlock();
        if (bl2) {
            element2.setAttribute("absolute-position", "fixed");
            element2.setAttribute("left", "0px");
            element2.setAttribute("top", "0px");
            element2.setAttribute("bottom", "0px");
            element2.setAttribute("min-width", n + "px");
            if (n2 != Integer.MAX_VALUE) {
                element2.setAttribute("max-width", n2 + "px");
            }
            element2.setAttribute("overflow", "hidden");
            element2.setAttribute("height", f + "pt");
            element2.setAttribute("keep-together.within-line", "always");
            element2.setAttribute("wrap-option", "no-wrap");
        }
        this.processCellStyle(hSSFWorkbook, hSSFCell.getCellStyle(), element, element2);
        element2.appendChild((Node)object);
        element.appendChild(element2);
        return ExcelToHtmlUtils.isEmpty(string) && bl3;
    }

    protected void processCellStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Element element, Element element2) {
        element2.setAttribute("white-space-collapse", "false");
        Object object = ExcelToFoUtils.getAlign(hSSFCellStyle.getAlignment());
        if (ExcelToFoUtils.isNotEmpty((String)object)) {
            element2.setAttribute("text-align", (String)object);
        }
        if (hSSFCellStyle.getFillPattern() != 0) {
            if (hSSFCellStyle.getFillPattern() == 1) {
                object = hSSFCellStyle.getFillForegroundColorColor();
                if (object != null) {
                    element.setAttribute("background-color", ExcelToFoUtils.getColor((HSSFColor)object));
                }
            } else {
                object = hSSFCellStyle.getFillBackgroundColorColor();
                if (object != null) {
                    element.setAttribute("background-color", ExcelToHtmlUtils.getColor((HSSFColor)object));
                }
            }
        }
        this.processCellStyleBorder(hSSFWorkbook, element, "top", hSSFCellStyle.getBorderTop(), hSSFCellStyle.getTopBorderColor());
        this.processCellStyleBorder(hSSFWorkbook, element, "right", hSSFCellStyle.getBorderRight(), hSSFCellStyle.getRightBorderColor());
        this.processCellStyleBorder(hSSFWorkbook, element, "bottom", hSSFCellStyle.getBorderBottom(), hSSFCellStyle.getBottomBorderColor());
        this.processCellStyleBorder(hSSFWorkbook, element, "left", hSSFCellStyle.getBorderLeft(), hSSFCellStyle.getLeftBorderColor());
        object = hSSFCellStyle.getFont(hSSFWorkbook);
        this.processCellStyleFont(hSSFWorkbook, element2, (HSSFFont)object);
    }

    protected void processCellStyleBorder(HSSFWorkbook hSSFWorkbook, Element element, String string, short s, short s2) {
        if (s == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ExcelToHtmlUtils.getBorderWidth(s));
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(s2);
        if (hSSFColor != null) {
            stringBuilder.append(' ');
            stringBuilder.append(ExcelToHtmlUtils.getColor(hSSFColor));
            stringBuilder.append(' ');
            stringBuilder.append(ExcelToHtmlUtils.getBorderStyle(s));
        }
        element.setAttribute("border-" + string, stringBuilder.toString());
    }

    protected void processCellStyleFont(HSSFWorkbook hSSFWorkbook, Element element, HSSFFont hSSFFont) {
        FontReplacer.Triplet triplet = new FontReplacer.Triplet();
        triplet.fontName = hSSFFont.getFontName();
        switch (hSSFFont.getBoldweight()) {
            case 700: {
                triplet.bold = true;
                break;
            }
            case 400: {
                triplet.bold = false;
            }
        }
        if (hSSFFont.getItalic()) {
            triplet.italic = true;
        }
        this.getFontReplacer().update(triplet);
        this.setBlockProperties(element, triplet);
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(hSSFFont.getColor());
        if (hSSFColor != null) {
            element.setAttribute("color", ExcelToHtmlUtils.getColor(hSSFColor));
        }
        if (hSSFFont.getFontHeightInPoints() != 0) {
            element.setAttribute("font-size", hSSFFont.getFontHeightInPoints() + "pt");
        }
    }

    protected void processColumnHeaders(HSSFSheet hSSFSheet, int n, Element element) {
        Element element2 = this.foDocumentFacade.createTableHeader();
        Element element3 = this.foDocumentFacade.createTableRow();
        if (this.isOutputRowNumbers()) {
            Element element4 = this.foDocumentFacade.createTableCell();
            element4.appendChild(this.foDocumentFacade.createBlock());
            element3.appendChild(element4);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i)) continue;
            Element element5 = this.foDocumentFacade.createTableCell();
            Element element6 = this.foDocumentFacade.createBlock();
            element6.setAttribute("text-align", "center");
            element6.setAttribute("font-weight", "bold");
            String string = this.getColumnName(i);
            element6.appendChild(this.foDocumentFacade.createText(string));
            element5.appendChild(element6);
            element3.appendChild(element5);
        }
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    protected float processColumnWidths(HSSFSheet hSSFSheet, int n, Element element) {
        float f = 0.0f;
        if (this.isOutputRowNumbers()) {
            float f2 = (float)ExcelToFoConverter.getDefaultColumnWidth(hSSFSheet) / 72.0f;
            Element element2 = this.foDocumentFacade.createTableColumn();
            element2.setAttribute("column-width", f2 + "in");
            element.appendChild(element2);
            f += f2;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i)) continue;
            float f3 = (float)ExcelToFoConverter.getColumnWidth(hSSFSheet, i) / 72.0f;
            Element element3 = this.foDocumentFacade.createTableColumn();
            element3.setAttribute("column-width", f3 + "in");
            element.appendChild(element3);
            f += f3;
        }
        element.setAttribute("width", f + "in");
        return f;
    }

    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (ExcelToFoUtils.isNotEmpty(summaryInformation.getTitle())) {
            this.foDocumentFacade.setTitle(summaryInformation.getTitle());
        }
        if (ExcelToFoUtils.isNotEmpty(summaryInformation.getAuthor())) {
            this.foDocumentFacade.setCreator(summaryInformation.getAuthor());
        }
        if (ExcelToFoUtils.isNotEmpty(summaryInformation.getKeywords())) {
            this.foDocumentFacade.setKeywords(summaryInformation.getKeywords());
        }
        if (ExcelToFoUtils.isNotEmpty(summaryInformation.getComments())) {
            this.foDocumentFacade.setDescription(summaryInformation.getComments());
        }
    }

    protected int processRow(HSSFWorkbook hSSFWorkbook, CellRangeAddress[][] cellRangeAddressArray, HSSFRow hSSFRow, Element element) {
        HSSFSheet hSSFSheet = hSSFRow.getSheet();
        int n = hSSFRow.getLastCellNum();
        if (n <= 0) {
            return 0;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        if (this.isOutputRowNumbers()) {
            Element element2 = this.processRowNumber(hSSFRow);
            arrayList.add(element2);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            CellRangeAddress cellRangeAddress;
            if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(i) || (cellRangeAddress = ExcelToHtmlUtils.getMergedRange(cellRangeAddressArray, hSSFRow.getRowNum(), i)) != null && (cellRangeAddress.getFirstColumn() != i || cellRangeAddress.getFirstRow() != hSSFRow.getRowNum())) continue;
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            int n4 = 0;
            n4 = ExcelToFoConverter.getColumnWidth(hSSFSheet, i);
            boolean bl = false;
            for (n3 = i + 1; n3 < n; ++n3) {
                if (!this.isOutputHiddenColumns() && hSSFSheet.isColumnHidden(n3)) continue;
                if (hSSFRow.getCell(n3) != null && !this.isTextEmpty(hSSFRow.getCell(n3))) {
                    bl = true;
                    break;
                }
                n4 += ExcelToFoConverter.getColumnWidth(hSSFSheet, n3);
            }
            if (!bl) {
                n4 = Integer.MAX_VALUE;
            }
            Element element3 = this.foDocumentFacade.createTableCell();
            if (cellRangeAddress != null) {
                if (cellRangeAddress.getFirstColumn() != cellRangeAddress.getLastColumn()) {
                    element3.setAttribute("number-columns-spanned", String.valueOf(cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1));
                }
                if (cellRangeAddress.getFirstRow() != cellRangeAddress.getLastRow()) {
                    element3.setAttribute("number-rows-spanned", String.valueOf(cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1));
                }
            }
            if (hSSFCell != null) {
                n3 = this.processCell(hSSFWorkbook, hSSFCell, element3, ExcelToFoConverter.getColumnWidth(hSSFSheet, i), n4, (float)hSSFRow.getHeight() / 20.0f) ? 1 : 0;
            } else {
                element3.appendChild(this.foDocumentFacade.createBlock());
                n3 = 1;
            }
            if (n3 != 0) {
                arrayList.add(element3);
                continue;
            }
            for (Element element4 : arrayList) {
                element.appendChild(element4);
            }
            arrayList.clear();
            element.appendChild(element3);
            n2 = i;
        }
        return n2 + 1;
    }

    protected Element processRowNumber(HSSFRow hSSFRow) {
        Element element = this.foDocumentFacade.createTableCell();
        Element element2 = this.foDocumentFacade.createBlock();
        element2.setAttribute("text-align", "right");
        element2.setAttribute("font-weight", "bold");
        Text text = this.foDocumentFacade.createText(this.getRowName(hSSFRow));
        element2.appendChild(text);
        element.appendChild(element2);
        return element;
    }

    protected float processSheet(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, Element element) {
        int n = hSSFSheet.getPhysicalNumberOfRows();
        if (n <= 0) {
            return 0.0f;
        }
        this.processSheetName(hSSFSheet, element);
        Element element2 = this.foDocumentFacade.createTable();
        element2.setAttribute("table-layout", "fixed");
        Element element3 = this.foDocumentFacade.createTableBody();
        CellRangeAddress[][] cellRangeAddressArray = ExcelToHtmlUtils.buildMergedRangesMap(hSSFSheet);
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 1;
        for (int i = hSSFSheet.getFirstRowNum(); i <= hSSFSheet.getLastRowNum(); ++i) {
            HSSFRow hSSFRow = hSSFSheet.getRow(i);
            if (hSSFRow == null || !this.isOutputHiddenRows() && hSSFRow.getZeroHeight()) continue;
            Element element4 = this.foDocumentFacade.createTableRow();
            element4.setAttribute("height", (float)hSSFRow.getHeight() / 20.0f + "pt");
            int n3 = this.processRow(hSSFWorkbook, cellRangeAddressArray, hSSFRow, element4);
            if (element4.getChildNodes().getLength() == 0) {
                Element element5 = this.foDocumentFacade.createTableCell();
                element5.appendChild(this.foDocumentFacade.createBlock());
                element4.appendChild(element5);
            }
            if (n3 == 0) {
                arrayList.add(element4);
            } else {
                if (!arrayList.isEmpty()) {
                    for (Element element6 : arrayList) {
                        element3.appendChild(element6);
                    }
                    arrayList.clear();
                }
                element3.appendChild(element4);
            }
            n2 = Math.max(n2, n3);
        }
        float f = this.processColumnWidths(hSSFSheet, n2, element2);
        if (this.isOutputColumnHeaders()) {
            this.processColumnHeaders(hSSFSheet, n2, element2);
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        return f;
    }

    protected boolean processSheet(HSSFWorkbook hSSFWorkbook, int n) {
        String string = "sheet-" + n;
        Element element = this.foDocumentFacade.createPageSequence(string);
        Element element2 = this.foDocumentFacade.addFlowToPageSequence(element, "xsl-region-body");
        HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
        float f = this.processSheet(hSSFWorkbook, hSSFSheet, element2);
        if (f == 0.0f) {
            return false;
        }
        this.createPageMaster(f, string);
        this.foDocumentFacade.addPageSequence(element);
        return true;
    }

    protected void processSheetName(HSSFSheet hSSFSheet, Element element) {
        Element element2 = this.foDocumentFacade.createBlock();
        FontReplacer.Triplet triplet = new FontReplacer.Triplet();
        triplet.bold = true;
        triplet.italic = false;
        triplet.fontName = "Arial";
        this.getFontReplacer().update(triplet);
        this.setBlockProperties(element2, triplet);
        element2.setAttribute("font-size", "200%");
        Element element3 = this.foDocumentFacade.createInline();
        element3.appendChild(this.foDocumentFacade.createText(hSSFSheet.getSheetName()));
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = this.foDocumentFacade.createBlock();
        Element element5 = this.foDocumentFacade.createInline();
        element4.appendChild(element5);
        element.appendChild(element4);
    }

    public void processWorkbook(HSSFWorkbook hSSFWorkbook) {
        SummaryInformation summaryInformation = hSSFWorkbook.getSummaryInformation();
        if (summaryInformation != null) {
            this.processDocumentInformation(summaryInformation);
        }
        for (int i = 0; i < hSSFWorkbook.getNumberOfSheets(); ++i) {
            this.processSheet(hSSFWorkbook, i);
        }
    }

    private void setBlockProperties(Element element, FontReplacer.Triplet triplet) {
        if (triplet.bold) {
            element.setAttribute("font-weight", "bold");
        }
        if (triplet.italic) {
            element.setAttribute("font-style", "italic");
        }
        if (ExcelToFoUtils.isNotEmpty(triplet.fontName)) {
            element.setAttribute("font-family", triplet.fontName);
        }
    }

    public void setPageMarginInches(float f) {
        this.pageMarginInches = f;
    }
}

