/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.converter;

import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AbstractExcelUtils {
    static final String EMPTY = "";
    private static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    private static final int UNIT_OFFSET_LENGTH = 7;

    public static String getAlign(short s) {
        switch (s) {
            case 2: {
                return "center";
            }
            case 6: {
                return "center";
            }
            case 4: {
                return EMPTY;
            }
            case 0: {
                return EMPTY;
            }
            case 5: {
                return "justify";
            }
            case 1: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return EMPTY;
    }

    public static String getBorderStyle(short s) {
        String string;
        switch (s) {
            case 0: {
                string = "none";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "dotted";
                break;
            }
            case 3: 
            case 8: {
                string = "dashed";
                break;
            }
            case 6: {
                string = "double";
                break;
            }
            default: {
                string = "solid";
            }
        }
        return string;
    }

    public static String getBorderWidth(short s) {
        String string;
        switch (s) {
            case 8: 
            case 10: 
            case 12: {
                string = "2pt";
                break;
            }
            case 5: {
                string = "thick";
                break;
            }
            default: {
                string = "thin";
            }
        }
        return string;
    }

    public static String getColor(HSSFColor hSSFColor) {
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append('#');
        for (short s : hSSFColor.getTriplet()) {
            if (s < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(s));
        }
        Object object = stringBuilder.toString();
        if (((String)object).equals("#ffffff")) {
            return "white";
        }
        if (((String)object).equals("#c0c0c0")) {
            return "silver";
        }
        if (((String)object).equals("#808080")) {
            return "gray";
        }
        if (((String)object).equals("#000000")) {
            return "black";
        }
        return object;
    }

    public static int getColumnWidthInPx(int n) {
        int n2 = n / 256 * 7;
        int n3 = n % 256;
        return n2 += Math.round((float)n3 / 36.57143f);
    }

    public static CellRangeAddress getMergedRange(CellRangeAddress[][] cellRangeAddressArray, int n, int n2) {
        CellRangeAddress[] cellRangeAddressArray2 = n < cellRangeAddressArray.length ? cellRangeAddressArray[n] : null;
        CellRangeAddress cellRangeAddress = cellRangeAddressArray2 != null && n2 < cellRangeAddressArray2.length ? cellRangeAddressArray2[n2] : null;
        return cellRangeAddress;
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static boolean isNotEmpty(String string) {
        return !AbstractExcelUtils.isEmpty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSFWorkbook loadXls(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(fileInputStream);
            return hSSFWorkbook;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }
}

