/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.converter;

import ai2.org.apache.poi.hssf.converter.ExcelToHtmlUtils;
import ai2.org.apache.poi.hssf.usermodel.HSSFCell;
import ai2.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai2.org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFRow;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hwpf.converter.DefaultFontReplacer;
import ai2.org.apache.poi.hwpf.converter.FontReplacer;
import ai2.org.apache.poi.hwpf.converter.NumberFormatter;
import ai2.org.apache.poi.ss.formula.eval.ErrorEval;
import org.w3c.dom.Document;

public abstract class AbstractExcelConverter {
    protected final HSSFDataFormatter _formatter = new HSSFDataFormatter();
    private FontReplacer fontReplacer = new DefaultFontReplacer();
    private boolean outputColumnHeaders = true;
    private boolean outputHiddenColumns = false;
    private boolean outputHiddenRows = false;
    private boolean outputLeadingSpacesAsNonBreaking = true;
    private boolean outputRowNumbers = true;

    protected static int getColumnWidth(HSSFSheet hSSFSheet, int n) {
        return ExcelToHtmlUtils.getColumnWidthInPx(hSSFSheet.getColumnWidth(n));
    }

    protected static int getDefaultColumnWidth(HSSFSheet hSSFSheet) {
        return ExcelToHtmlUtils.getColumnWidthInPx(hSSFSheet.getDefaultColumnWidth());
    }

    protected String getColumnName(int n) {
        return NumberFormatter.getNumber(n + 1, 3);
    }

    protected abstract Document getDocument();

    public FontReplacer getFontReplacer() {
        return this.fontReplacer;
    }

    protected String getRowName(HSSFRow hSSFRow) {
        return String.valueOf(hSSFRow.getRowNum() + 1);
    }

    public boolean isOutputColumnHeaders() {
        return this.outputColumnHeaders;
    }

    public boolean isOutputHiddenColumns() {
        return this.outputHiddenColumns;
    }

    public boolean isOutputHiddenRows() {
        return this.outputHiddenRows;
    }

    public boolean isOutputLeadingSpacesAsNonBreaking() {
        return this.outputLeadingSpacesAsNonBreaking;
    }

    public boolean isOutputRowNumbers() {
        return this.outputRowNumbers;
    }

    protected boolean isTextEmpty(HSSFCell hSSFCell) {
        String string;
        block0 : switch (hSSFCell.getCellType()) {
            case 1: {
                string = hSSFCell.getRichStringCellValue().getString();
                break;
            }
            case 2: {
                switch (hSSFCell.getCachedFormulaResultType()) {
                    case 1: {
                        HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                        if (hSSFRichTextString == null || hSSFRichTextString.length() <= 0) {
                            return false;
                        }
                        string = hSSFRichTextString.toString();
                        break block0;
                    }
                    case 0: {
                        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
                        if (hSSFCellStyle == null) {
                            return false;
                        }
                        string = this._formatter.formatRawCellContents(hSSFCell.getNumericCellValue(), hSSFCellStyle.getDataFormat(), hSSFCellStyle.getDataFormatString());
                        break block0;
                    }
                    case 4: {
                        string = String.valueOf(hSSFCell.getBooleanCellValue());
                        break block0;
                    }
                    case 5: {
                        string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                        break block0;
                    }
                }
                string = "";
                break;
            }
            case 3: {
                string = "";
                break;
            }
            case 0: {
                string = this._formatter.formatCellValue(hSSFCell);
                break;
            }
            case 4: {
                string = String.valueOf(hSSFCell.getBooleanCellValue());
                break;
            }
            case 5: {
                string = ErrorEval.getText(hSSFCell.getErrorCellValue());
                break;
            }
            default: {
                return true;
            }
        }
        return ExcelToHtmlUtils.isEmpty(string);
    }

    public void setFontReplacer(FontReplacer fontReplacer) {
        this.fontReplacer = fontReplacer;
    }

    public void setOutputColumnHeaders(boolean bl) {
        this.outputColumnHeaders = bl;
    }

    public void setOutputHiddenColumns(boolean bl) {
        this.outputHiddenColumns = bl;
    }

    public void setOutputHiddenRows(boolean bl) {
        this.outputHiddenRows = bl;
    }

    public void setOutputLeadingSpacesAsNonBreaking(boolean bl) {
        this.outputLeadingSpacesAsNonBreaking = bl;
    }

    public void setOutputRowNumbers(boolean bl) {
        this.outputRowNumbers = bl;
    }
}

