/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.hsmf.MAPIMessage;
import ai2.org.apache.poi.hsmf.datatypes.AttachmentChunks;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class OutlookTextExtactor
extends POIOLE2TextExtractor {
    public OutlookTextExtactor(MAPIMessage mAPIMessage) {
        super(mAPIMessage);
    }

    @Deprecated
    public OutlookTextExtactor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new MAPIMessage(directoryNode, pOIFSFileSystem));
    }

    public OutlookTextExtactor(DirectoryNode directoryNode) throws IOException {
        this(new MAPIMessage(directoryNode));
    }

    public OutlookTextExtactor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(new MAPIMessage(nPOIFSFileSystem));
    }

    public OutlookTextExtactor(InputStream inputStream) throws IOException {
        this(new MAPIMessage(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            NPOIFSFileSystem nPOIFSFileSystem = null;
            POITextExtractor pOITextExtractor = null;
            try {
                nPOIFSFileSystem = new NPOIFSFileSystem(new File(string));
                pOITextExtractor = new OutlookTextExtactor(nPOIFSFileSystem);
                System.out.println(((OutlookTextExtactor)pOITextExtractor).getText());
            }
            finally {
                if (pOITextExtractor != null) {
                    pOITextExtractor.close();
                }
                if (nPOIFSFileSystem != null) {
                    nPOIFSFileSystem.close();
                }
            }
        }
    }

    public MAPIMessage getMAPIMessage() {
        return (MAPIMessage)this.document;
    }

    public String getText() {
        StringUtil.StringsIterator stringsIterator;
        MAPIMessage mAPIMessage = (MAPIMessage)this.document;
        StringBuffer stringBuffer = new StringBuffer();
        mAPIMessage.guess7BitEncoding();
        try {
            stringsIterator = new StringUtil.StringsIterator(mAPIMessage.getRecipientEmailAddressList());
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            stringsIterator = new StringUtil.StringsIterator(new String[0]);
        }
        try {
            stringBuffer.append("From: " + mAPIMessage.getDisplayFrom() + "\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        try {
            this.handleEmails(stringBuffer, "To", mAPIMessage.getDisplayTo(), stringsIterator);
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        try {
            this.handleEmails(stringBuffer, "CC", mAPIMessage.getDisplayCC(), stringsIterator);
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        try {
            this.handleEmails(stringBuffer, "BCC", mAPIMessage.getDisplayBCC(), stringsIterator);
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        try {
            AttachmentChunks[] attachmentChunksArray = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.ROOT);
            attachmentChunksArray.setTimeZone(LocaleUtil.getUserTimeZone());
            stringBuffer.append("Date: " + attachmentChunksArray.format(mAPIMessage.getMessageDate().getTime()) + "\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            try {
                String[] stringArray;
                for (String string : stringArray = mAPIMessage.getHeaders()) {
                    if (!string.toLowerCase(Locale.ROOT).startsWith("date:")) continue;
                    stringBuffer.append("Date:" + string.substring(string.indexOf(58) + 1) + "\n");
                }
            }
            catch (ChunkNotFoundException chunkNotFoundException2) {
                // empty catch block
            }
        }
        try {
            stringBuffer.append("Subject: " + mAPIMessage.getSubject() + "\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        for (AttachmentChunks attachmentChunks : mAPIMessage.getAttachmentFiles()) {
            String string;
            StringChunk stringChunk = attachmentChunks.attachLongFileName;
            if (stringChunk == null) {
                stringChunk = attachmentChunks.attachFileName;
            }
            string = stringChunk.getValue();
            if (attachmentChunks.attachMimeTag != null && attachmentChunks.attachMimeTag.getValue() != null) {
                string = attachmentChunks.attachMimeTag.getValue() + " = " + string;
            }
            stringBuffer.append("Attachment: " + string + "\n");
        }
        try {
            stringBuffer.append("\n" + mAPIMessage.getTextBody() + "\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    protected void handleEmails(StringBuffer stringBuffer, String string, String string2, StringUtil.StringsIterator stringsIterator) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        String[] stringArray = string2.split(";\\s*");
        boolean bl = true;
        stringBuffer.append(string + ": ");
        for (String string3 : stringArray) {
            String string4;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            stringBuffer.append(string3);
            if (!stringsIterator.hasNext() || (string4 = stringsIterator.next()).equals(string3)) continue;
            stringBuffer.append(" <" + string4 + ">");
        }
        stringBuffer.append("\n");
    }
}

