/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StringChunk
extends Chunk {
    private static final String DEFAULT_ENCODING = "CP1252";
    private String encoding7Bit = "CP1252";
    private byte[] rawValue;
    private String value;

    public StringChunk(String string, int n, Types.MAPIType mAPIType) {
        super(string, n, mAPIType);
    }

    public StringChunk(int n, Types.MAPIType mAPIType) {
        super(n, mAPIType);
    }

    public String get7BitEncoding() {
        return this.encoding7Bit;
    }

    public void set7BitEncoding(String string) {
        this.encoding7Bit = string;
        if (this.type == Types.ASCII_STRING) {
            this.parseString();
        }
    }

    public void readValue(InputStream inputStream) throws IOException {
        this.rawValue = IOUtils.toByteArray(inputStream);
        this.parseString();
    }

    private void parseString() {
        String string;
        if (this.type == Types.ASCII_STRING) {
            string = StringChunk.parseAs7BitData(this.rawValue, this.encoding7Bit);
        } else if (this.type == Types.UNICODE_STRING) {
            string = StringUtil.getFromUnicodeLE(this.rawValue);
        } else {
            throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
        }
        this.value = string.replace("\u0000", "");
    }

    public void writeValue(OutputStream outputStream) throws IOException {
        outputStream.write(this.rawValue);
    }

    private void storeString() {
        if (this.type == Types.ASCII_STRING) {
            this.rawValue = this.value.getBytes(Charset.forName(this.encoding7Bit));
        } else if (this.type == Types.UNICODE_STRING) {
            this.rawValue = StringUtil.getToUnicodeLE(this.value);
        } else {
            throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
        }
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getRawValue() {
        return this.rawValue;
    }

    public void setValue(String string) {
        this.value = string;
        this.storeString();
    }

    public String toString() {
        return this.value;
    }

    protected static String parseAs7BitData(byte[] byArray) {
        return StringChunk.parseAs7BitData(byArray, DEFAULT_ENCODING);
    }

    protected static String parseAs7BitData(byte[] byArray, String string) {
        if ("ansi".equals(string)) {
            string = DEFAULT_ENCODING;
        }
        return new String(byArray, Charset.forName(string));
    }
}

