/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf.datatypes;

import ai2.org.apache.poi.hsmf.datatypes.ByteChunk;
import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroupWithProperties;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.PropertiesChunk;
import ai2.org.apache.poi.hsmf.datatypes.PropertyValue;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecipientChunks
implements ChunkGroupWithProperties {
    private static POILogger logger = POILogFactory.getLogger(RecipientChunks.class);
    public static final String PREFIX = "__recip_version1.0_#";
    public static final MAPIProperty RECIPIENT_NAME = MAPIProperty.DISPLAY_NAME;
    public static final MAPIProperty DELIVERY_TYPE = MAPIProperty.ADDRTYPE;
    public static final MAPIProperty RECIPIENT_EMAIL_ADDRESS = MAPIProperty.EMAIL_ADDRESS;
    public static final MAPIProperty RECIPIENT_SEARCH = MAPIProperty.SEARCH_KEY;
    public static final MAPIProperty RECIPIENT_SMTP_ADDRESS = MAPIProperty.SMTP_ADDRESS;
    public static final MAPIProperty RECIPIENT_DISPLAY_NAME = MAPIProperty.RECIPIENT_DISPLAY_NAME;
    public int recipientNumber = -1;
    public ByteChunk recipientSearchChunk;
    public StringChunk recipientNameChunk;
    public StringChunk recipientEmailChunk;
    public StringChunk recipientSMTPChunk;
    public StringChunk deliveryTypeChunk;
    public StringChunk recipientDisplayNameChunk;
    private PropertiesChunk recipientProperties;
    private List<Chunk> allChunks = new ArrayList<Chunk>();

    public RecipientChunks(String string) {
        int n = string.lastIndexOf(35);
        if (n > -1) {
            String string2 = string.substring(n + 1);
            try {
                this.recipientNumber = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(7, new Object[]{"Invalid recipient number in name " + string});
            }
        }
    }

    public String getRecipientName() {
        if (this.recipientNameChunk != null) {
            return this.recipientNameChunk.getValue();
        }
        if (this.recipientDisplayNameChunk != null) {
            return this.recipientDisplayNameChunk.getValue();
        }
        return null;
    }

    public String getRecipientEmailAddress() {
        String string;
        if (this.recipientSMTPChunk != null) {
            return this.recipientSMTPChunk.getValue();
        }
        if (this.recipientEmailChunk != null) {
            String string2 = this.recipientEmailChunk.getValue();
            int n = string2.indexOf("/CN=");
            if (n == -1) {
                return string2;
            }
            return string2.substring(n + 4);
        }
        if (this.recipientNameChunk != null && (string = this.recipientNameChunk.getValue()).indexOf(64) > -1) {
            if (string.startsWith("'") && string.endsWith("'")) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
        if (this.recipientSearchChunk != null && (string = this.recipientSearchChunk.getAs7bitString()).indexOf("SMTP:") != -1) {
            return string.substring(string.indexOf("SMTP:") + 5);
        }
        return null;
    }

    @Override
    public Map<MAPIProperty, List<PropertyValue>> getProperties() {
        if (this.recipientProperties != null) {
            return this.recipientProperties.getProperties();
        }
        return Collections.emptyMap();
    }

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    @Override
    public Chunk[] getChunks() {
        return this.getAll();
    }

    @Override
    public void record(Chunk chunk) {
        if (chunk.getChunkId() == RecipientChunks.RECIPIENT_SEARCH.id) {
            this.recipientSearchChunk = (ByteChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_NAME.id) {
            this.recipientDisplayNameChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_DISPLAY_NAME.id) {
            this.recipientNameChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_EMAIL_ADDRESS.id) {
            this.recipientEmailChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.RECIPIENT_SMTP_ADDRESS.id) {
            this.recipientSMTPChunk = (StringChunk)chunk;
        } else if (chunk.getChunkId() == RecipientChunks.DELIVERY_TYPE.id) {
            this.deliveryTypeChunk = (StringChunk)chunk;
        } else if (chunk instanceof PropertiesChunk) {
            this.recipientProperties = (PropertiesChunk)chunk;
        }
        this.allChunks.add(chunk);
    }

    @Override
    public void chunksComplete() {
        if (this.recipientProperties != null) {
            this.recipientProperties.matchVariableSizedPropertiesToChunks();
        } else {
            logger.log(5, new Object[]{"Recipeints Chunk didn't contain a list of properties!"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecipientChunksSorter
    implements Comparator<RecipientChunks> {
        @Override
        public int compare(RecipientChunks recipientChunks, RecipientChunks recipientChunks2) {
            if (recipientChunks.recipientNumber < recipientChunks2.recipientNumber) {
                return -1;
            }
            if (recipientChunks.recipientNumber > recipientChunks2.recipientNumber) {
                return 1;
            }
            return 0;
        }
    }
}

