/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hsmf;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import ai2.org.apache.poi.hsmf.datatypes.AttachmentChunks;
import ai2.org.apache.poi.hsmf.datatypes.ByteChunk;
import ai2.org.apache.poi.hsmf.datatypes.Chunk;
import ai2.org.apache.poi.hsmf.datatypes.ChunkGroup;
import ai2.org.apache.poi.hsmf.datatypes.Chunks;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.NameIdChunks;
import ai2.org.apache.poi.hsmf.datatypes.PropertyValue;
import ai2.org.apache.poi.hsmf.datatypes.RecipientChunks;
import ai2.org.apache.poi.hsmf.datatypes.StringChunk;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import ai2.org.apache.poi.hsmf.parsers.POIFSChunkParser;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.CodePageUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MAPIMessage
extends POIDocument {
    private POILogger logger = POILogFactory.getLogger(MAPIMessage.class);
    private Chunks mainChunks;
    private NameIdChunks nameIdChunks;
    private RecipientChunks[] recipientChunks;
    private AttachmentChunks[] attachmentChunks;
    private boolean returnNullOnMissingChunk = false;

    public MAPIMessage() {
        super(new NPOIFSFileSystem());
    }

    public MAPIMessage(String string) throws IOException {
        this(new NPOIFSFileSystem(new File(string)));
    }

    public MAPIMessage(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public MAPIMessage(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    @Deprecated
    public MAPIMessage(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public MAPIMessage(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        ChunkGroup[] chunkGroupArray = POIFSChunkParser.parse(directoryNode);
        ArrayList<AttachmentChunks> arrayList = new ArrayList<AttachmentChunks>();
        ArrayList<RecipientChunks> arrayList2 = new ArrayList<RecipientChunks>();
        for (ChunkGroup chunkGroup : chunkGroupArray) {
            if (chunkGroup instanceof Chunks) {
                this.mainChunks = (Chunks)chunkGroup;
            } else if (chunkGroup instanceof NameIdChunks) {
                this.nameIdChunks = (NameIdChunks)chunkGroup;
            } else if (chunkGroup instanceof RecipientChunks) {
                arrayList2.add((RecipientChunks)chunkGroup);
            }
            if (!(chunkGroup instanceof AttachmentChunks)) continue;
            arrayList.add((AttachmentChunks)chunkGroup);
        }
        this.attachmentChunks = arrayList.toArray(new AttachmentChunks[arrayList.size()]);
        this.recipientChunks = arrayList2.toArray(new RecipientChunks[arrayList2.size()]);
        Arrays.sort(this.attachmentChunks, new AttachmentChunks.AttachmentChunksSorter());
        Arrays.sort(this.recipientChunks, new RecipientChunks.RecipientChunksSorter());
    }

    public String getStringFromChunk(StringChunk stringChunk) throws ChunkNotFoundException {
        if (stringChunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        return stringChunk.getValue();
    }

    public String getTextBody() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.textBodyChunk);
    }

    public String getHtmlBody() throws ChunkNotFoundException {
        if (this.mainChunks.htmlBodyChunkBinary != null) {
            return this.mainChunks.htmlBodyChunkBinary.getAs7bitString();
        }
        return this.getStringFromChunk(this.mainChunks.htmlBodyChunkString);
    }

    @Deprecated
    public String getHmtlBody() throws ChunkNotFoundException {
        return this.getHtmlBody();
    }

    public String getRtfBody() throws ChunkNotFoundException {
        ByteChunk byteChunk = this.mainChunks.rtfBodyChunk;
        if (byteChunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        try {
            MAPIRtfAttribute mAPIRtfAttribute = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), byteChunk.getValue());
            return mAPIRtfAttribute.getDataString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Shouldn't happen", iOException);
        }
    }

    public String getSubject() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.subjectChunk);
    }

    public String getDisplayFrom() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayFromChunk);
    }

    public String getDisplayTo() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayToChunk);
    }

    public String getDisplayCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayCCChunk);
    }

    public String getDisplayBCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayBCCChunk);
    }

    public String getRecipientEmailAddress() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientEmailAddressList());
    }

    public String[] getRecipientEmailAddressList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] stringArray = new String[this.recipientChunks.length];
        for (int i = 0; i < stringArray.length; ++i) {
            RecipientChunks recipientChunks = this.recipientChunks[i];
            String string = recipientChunks.getRecipientEmailAddress();
            if (string != null) {
                stringArray[i] = string;
                continue;
            }
            if (this.returnNullOnMissingChunk) {
                stringArray[i] = null;
                continue;
            }
            throw new ChunkNotFoundException("No email address holding chunks found for the " + (i + 1) + "th recipient");
        }
        return stringArray;
    }

    public String getRecipientNames() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientNamesList());
    }

    public String[] getRecipientNamesList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] stringArray = new String[this.recipientChunks.length];
        for (int i = 0; i < stringArray.length; ++i) {
            RecipientChunks recipientChunks = this.recipientChunks[i];
            String string = recipientChunks.getRecipientName();
            if (string == null) {
                throw new ChunkNotFoundException("No display name holding chunks found for the " + (i + 1) + "th recipient");
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public void guess7BitEncoding() {
        Object object;
        for (MAPIProperty mAPIProperty : new MAPIProperty[]{MAPIProperty.MESSAGE_CODEPAGE, MAPIProperty.INTERNET_CPID}) {
            List<PropertyValue> list = this.mainChunks.getProperties().get(mAPIProperty);
            if (list == null || list.size() <= 0) continue;
            int n = ((PropertyValue.LongPropertyValue)list.get(0)).getValue();
            try {
                String string = CodePageUtil.codepageToEncoding(n, true);
                this.set7BitEncoding(string);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.logger.log(5, "Invalid codepage ID ", n, " set for the message via ", mAPIProperty, ", ignoring");
            }
        }
        try {
            object = this.getHeaders();
            if (object != null && ((Object[])object).length > 0) {
                Pattern pattern = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                for (Object object2 : object) {
                    Matcher matcher;
                    if (!((String)object2).startsWith("Content-Type") || !(matcher = pattern.matcher((CharSequence)object2)).matches()) continue;
                    String string = matcher.group(1);
                    if (!string.equalsIgnoreCase("utf-8")) {
                        this.set7BitEncoding(string);
                    }
                    return;
                }
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        try {
            Pattern pattern;
            Matcher matcher;
            object = this.getHmtlBody();
            if (object != null && ((String)object).length() > 0 && (matcher = (pattern = Pattern.compile("<META\\s+HTTP-EQUIV=\"Content-Type\"\\s+CONTENT=\"text/html;\\s+charset=(.*?)\"")).matcher((CharSequence)object)).find()) {
                String string = matcher.group(1);
                this.set7BitEncoding(string);
                return;
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
    }

    public void set7BitEncoding(String string) {
        for (Chunk object : this.mainChunks.getChunks()) {
            if (!(object instanceof StringChunk)) continue;
            ((StringChunk)object).set7BitEncoding(string);
        }
        if (this.nameIdChunks != null) {
            for (Chunk chunk : this.nameIdChunks.getChunks()) {
                if (!(chunk instanceof StringChunk)) continue;
                ((StringChunk)chunk).set7BitEncoding(string);
            }
        }
        for (RecipientChunks recipientChunks : this.recipientChunks) {
            for (Chunk chunk : recipientChunks.getAll()) {
                if (!(chunk instanceof StringChunk)) continue;
                ((StringChunk)chunk).set7BitEncoding(string);
            }
        }
    }

    public boolean has7BitEncodingStrings() {
        for (Chunk object : this.mainChunks.getChunks()) {
            if (!(object instanceof StringChunk) || ((StringChunk)object).getType() != Types.ASCII_STRING) continue;
            return true;
        }
        if (this.nameIdChunks != null) {
            for (Chunk chunk : this.nameIdChunks.getChunks()) {
                if (!(chunk instanceof StringChunk) || ((StringChunk)chunk).getType() != Types.ASCII_STRING) continue;
                return true;
            }
        }
        for (RecipientChunks recipientChunks : this.recipientChunks) {
            for (Chunk chunk : recipientChunks.getAll()) {
                if (!(chunk instanceof StringChunk) || ((StringChunk)chunk).getType() != Types.ASCII_STRING) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getHeaders() throws ChunkNotFoundException {
        String string = this.getStringFromChunk(this.mainChunks.messageHeaders);
        if (string == null) {
            return null;
        }
        return string.split("\\r?\\n");
    }

    public String getConversationTopic() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.conversationTopic);
    }

    public String getMessageClass() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.messageClass);
    }

    public Calendar getMessageDate() throws ChunkNotFoundException {
        if (this.mainChunks.submissionChunk != null) {
            return this.mainChunks.submissionChunk.getAcceptedAtTime();
        }
        for (MAPIProperty mAPIProperty : new MAPIProperty[]{MAPIProperty.CLIENT_SUBMIT_TIME, MAPIProperty.LAST_MODIFICATION_TIME, MAPIProperty.CREATION_TIME}) {
            List<PropertyValue> list = this.mainChunks.getProperties().get(mAPIProperty);
            if (list == null || list.size() <= 0) continue;
            return ((PropertyValue.TimePropertyValue)list.get(0)).getValue();
        }
        if (this.returnNullOnMissingChunk) {
            return null;
        }
        throw new ChunkNotFoundException();
    }

    public Chunks getMainChunks() {
        return this.mainChunks;
    }

    public RecipientChunks[] getRecipientDetailsChunks() {
        return this.recipientChunks;
    }

    public NameIdChunks getNameIdChunks() {
        return this.nameIdChunks;
    }

    public AttachmentChunks[] getAttachmentFiles() {
        return this.attachmentChunks;
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Writing isn't yet supported for HSMF, sorry");
    }

    public boolean isReturnNullOnMissingChunk() {
        return this.returnNullOnMissingChunk;
    }

    public void setReturnNullOnMissingChunk(boolean bl) {
        this.returnNullOnMissingChunk = bl;
    }

    private String toSemicolonList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : stringArray) {
            if (string == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

