/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.record.Slide;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFTitleMaster
extends HSLFMasterSheet {
    private final List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();

    public HSLFTitleMaster(Slide slide, int n) {
        super(slide, n);
        for (List<HSLFTextParagraph> list : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(list)) continue;
            this._paragraphs.add(list);
        }
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    @Override
    public TextProp getStyleAttribute(int n, int n2, String string, boolean bl) {
        HSLFMasterSheet hSLFMasterSheet = this.getMasterSheet();
        return hSLFMasterSheet == null ? null : hSLFMasterSheet.getStyleAttribute(n, n2, string, bl);
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        List<HSLFSlideMaster> list = this.getSlideShow().getSlideMasters();
        SlideAtom slideAtom = ((Slide)this.getSheetContainer()).getSlideAtom();
        int n = slideAtom.getMasterID();
        for (HSLFSlideMaster hSLFSlideMaster : list) {
            if (n != hSLFSlideMaster._getSheetNumber()) continue;
            return hSLFSlideMaster;
        }
        return null;
    }
}

