/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.InteractiveInfo;
import ai2.org.apache.poi.hslf.record.InteractiveInfoAtom;
import ai2.org.apache.poi.hslf.record.OEPlaceholderAtom;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.RoundTripHFPlaceholder12;
import ai2.org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFHyperlink;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextRun;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawTextShape;
import ai2.org.apache.poi.sl.usermodel.Insets2D;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.TextShape;
import ai2.org.apache.poi.sl.usermodel.VerticalAlignment;
import ai2.org.apache.poi.util.Units;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSLFTextShape
extends HSLFSimpleShape
implements TextShape<HSLFShape, HSLFTextParagraph> {
    static final int AnchorTop = 0;
    static final int AnchorMiddle = 1;
    static final int AnchorBottom = 2;
    static final int AnchorTopCentered = 3;
    static final int AnchorMiddleCentered = 4;
    static final int AnchorBottomCentered = 5;
    static final int AnchorTopBaseline = 6;
    static final int AnchorBottomBaseline = 7;
    static final int AnchorTopCenteredBaseline = 8;
    static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    protected List<HSLFTextParagraph> _paragraphs = new ArrayList<HSLFTextParagraph>();
    protected EscherTextboxWrapper _txtbox;
    boolean alignToBaseline = false;
    protected static final FontRenderContext _frc = new FontRenderContext(null, true, true);

    protected HSLFTextShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public HSLFTextShape(ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(null, shapeContainer);
        this._escherContainer = this.createSpContainer(shapeContainer instanceof HSLFGroupShape);
    }

    public HSLFTextShape() {
        this(null);
    }

    protected void setDefaultTextProperties(HSLFTextParagraph hSLFTextParagraph) {
    }

    @Override
    protected void afterInsert(HSLFSheet hSLFSheet) {
        super.afterInsert(hSLFSheet);
        this.storeText();
        EscherTextboxWrapper escherTextboxWrapper = this.getEscherTextboxWrapper();
        if (escherTextboxWrapper != null) {
            this._escherContainer.addChildRecord(escherTextboxWrapper.getEscherRecord());
            PPDrawing pPDrawing = hSLFSheet.getPPDrawing();
            pPDrawing.addTextboxWrapper(escherTextboxWrapper);
            try {
                escherTextboxWrapper.writeOut(null);
            }
            catch (IOException iOException) {
                throw new HSLFException(iOException);
            }
            if (this.getAnchor().equals(new Rectangle()) && !"".equals(this.getText())) {
                this.resizeToFitText();
            }
        }
        for (HSLFTextParagraph hSLFTextParagraph : this._paragraphs) {
            hSLFTextParagraph.setShapeId(this.getShapeId());
        }
        hSLFSheet.onAddTextShape(this);
    }

    protected EscherTextboxWrapper getEscherTextboxWrapper() {
        EscherTextboxWrapper[] escherTextboxWrapperArray;
        PPDrawing pPDrawing;
        if (this._txtbox != null) {
            return this._txtbox;
        }
        EscherTextboxRecord escherTextboxRecord = (EscherTextboxRecord)this.getEscherChild(-4083);
        if (escherTextboxRecord == null) {
            return null;
        }
        HSLFSheet hSLFSheet = this.getSheet();
        if (hSLFSheet != null && (pPDrawing = hSLFSheet.getPPDrawing()) != null && (escherTextboxWrapperArray = pPDrawing.getTextboxWrappers()) != null) {
            for (EscherTextboxWrapper escherTextboxWrapper : escherTextboxWrapperArray) {
                if (escherTextboxRecord != escherTextboxWrapper.getEscherRecord()) continue;
                this._txtbox = escherTextboxWrapper;
                return this._txtbox;
            }
        }
        this._txtbox = new EscherTextboxWrapper(escherTextboxRecord);
        return this._txtbox;
    }

    public Rectangle2D resizeToFitText() {
        Rectangle rectangle = this.getAnchor();
        if (rectangle.getWidth() == 0.0) {
            this.logger.log(5, new Object[]{"Width of shape wasn't set. Defaulting to 200px"});
            rectangle.setSize(200, (int)rectangle.getHeight());
            this.setAnchor(rectangle);
        }
        double d = this.getTextHeight();
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), d += 1.0);
        this.setAnchor(rectangle);
        return rectangle;
    }

    public int getRunType() {
        this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            return -1;
        }
        List<HSLFTextParagraph> list = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
        return list.isEmpty() ? -1 : list.get(0).getRunType();
    }

    public void setRunType(int n) {
        this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            return;
        }
        List<HSLFTextParagraph> list = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
        if (!list.isEmpty()) {
            list.get(0).setRunType(n);
        }
    }

    int getAlignment() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(abstractEscherOptRecord, 135);
        int n = 0;
        if (escherSimpleProperty == null) {
            int n2 = this.getRunType();
            if (this.getSheet() != null && this.getSheet().getMasterSheet() != null) {
                HSLFMasterSheet hSLFMasterSheet = this.getSheet().getMasterSheet();
                HSLFTextShape hSLFTextShape = hSLFMasterSheet.getPlaceholderByTextType(n2);
                if (hSLFTextShape != null) {
                    n = hSLFTextShape.getAlignment();
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 6: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
            }
        } else {
            n = escherSimpleProperty.getPropertyValue();
        }
        this.alignToBaseline = n == 7 || n == 9 || n == 6 || n == 8;
        return n;
    }

    void setAlignment(Boolean bl, VerticalAlignment verticalAlignment) {
        int[] nArray;
        switch (verticalAlignment) {
            case TOP: {
                nArray = new int[]{0, 3, 6, 8};
                break;
            }
            default: {
                nArray = new int[]{1, 4, 1, 4};
                break;
            }
            case BOTTOM: {
                nArray = new int[]{2, 5, 7, 9};
            }
        }
        int n = nArray[(bl != false ? 1 : 0) + (this.alignToBaseline ? 2 : 0)];
        this.setEscherProperty((short)135, n);
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        int n = this.getAlignment();
        switch (n) {
            case 0: 
            case 3: 
            case 6: 
            case 8: {
                return VerticalAlignment.TOP;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                return VerticalAlignment.BOTTOM;
            }
        }
        return VerticalAlignment.MIDDLE;
    }

    public boolean isAlignToBaseline() {
        this.getAlignment();
        return this.alignToBaseline;
    }

    public void setAlignToBaseline(boolean bl) {
        this.alignToBaseline = bl;
        this.setAlignment(this.isHorizontalCentered(), this.getVerticalAlignment());
    }

    @Override
    public boolean isHorizontalCentered() {
        int n = this.getAlignment();
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.setAlignment(this.isHorizontalCentered(), verticalAlignment);
    }

    public void setHorizontalCentered(Boolean bl) {
        this.setAlignment(bl, this.getVerticalAlignment());
    }

    public double getBottomInset() {
        return this.getInset((short)132, 0.05);
    }

    public void setBottomInset(double d) {
        this.setInset((short)132, d);
    }

    public double getLeftInset() {
        return this.getInset((short)129, 0.1);
    }

    public void setLeftInset(double d) {
        this.setInset((short)129, d);
    }

    public double getRightInset() {
        return this.getInset((short)131, 0.1);
    }

    public void setRightInset(double d) {
        this.setInset((short)131, d);
    }

    public double getTopInset() {
        return this.getInset((short)130, 0.05);
    }

    public void setTopInset(double d) {
        this.setInset((short)130, d);
    }

    private double getInset(short s, double d) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(abstractEscherOptRecord, s);
        int n = escherSimpleProperty == null ? (int)((double)Units.toEMU(72.0) * d) : escherSimpleProperty.getPropertyValue();
        return Units.toPoints(n);
    }

    private void setInset(short s, double d) {
        this.setEscherProperty(s, Units.toEMU(d));
    }

    @Override
    public boolean getWordWrap() {
        int n = this.getWordWrapEx();
        return n != 2;
    }

    public int getWordWrapEx() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(abstractEscherOptRecord, 133);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setWordWrap(int n) {
        this.setEscherProperty((short)133, n);
    }

    public int getTextId() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFTextShape.getEscherProperty(abstractEscherOptRecord, 128);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setTextId(int n) {
        this.setEscherProperty((short)128, n);
    }

    @Override
    public List<HSLFTextParagraph> getTextParagraphs() {
        if (!this._paragraphs.isEmpty()) {
            return this._paragraphs;
        }
        this._txtbox = this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            this._paragraphs.addAll(HSLFTextParagraph.createEmptyParagraph());
            this._txtbox = this._paragraphs.get(0).getTextboxWrapper();
        } else {
            this._paragraphs = HSLFTextParagraph.findTextParagraphs(this._txtbox, this.getSheet());
            if (this._paragraphs == null) {
                this._paragraphs = HSLFTextParagraph.createEmptyParagraph(this._txtbox);
            }
            if (this._paragraphs.isEmpty()) {
                this.logger.log(5, new Object[]{"TextRecord didn't contained any text lines"});
            }
        }
        for (HSLFTextParagraph hSLFTextParagraph : this._paragraphs) {
            hSLFTextParagraph.setParentShape(this);
        }
        return this._paragraphs;
    }

    @Override
    public void setSheet(HSLFSheet hSLFSheet) {
        this._sheet = hSLFSheet;
        List<HSLFTextParagraph> list = this.getTextParagraphs();
        if (list != null) {
            for (HSLFTextParagraph hSLFTextParagraph : list) {
                hSLFTextParagraph.supplySheet(this._sheet);
            }
        }
    }

    public OEPlaceholderAtom getPlaceholderAtom() {
        return (OEPlaceholderAtom)this.getClientDataRecord(RecordTypes.OEPlaceholderAtom.typeID);
    }

    public void setHyperlink(int n, int n2, int n3) {
        InteractiveInfo interactiveInfo = new InteractiveInfo();
        InteractiveInfoAtom interactiveInfoAtom = interactiveInfo.getInteractiveInfoAtom();
        interactiveInfoAtom.setAction((byte)4);
        interactiveInfoAtom.setHyperlinkType((byte)8);
        interactiveInfoAtom.setHyperlinkID(n);
        this._txtbox.appendChildRecord(interactiveInfo);
        TxInteractiveInfoAtom txInteractiveInfoAtom = new TxInteractiveInfoAtom();
        txInteractiveInfoAtom.setStartIndex(n2);
        txInteractiveInfoAtom.setEndIndex(n3);
        this._txtbox.appendChildRecord(txInteractiveInfoAtom);
    }

    @Override
    public boolean isPlaceholder() {
        OEPlaceholderAtom oEPlaceholderAtom = this.getPlaceholderAtom();
        if (oEPlaceholderAtom != null) {
            return true;
        }
        RoundTripHFPlaceholder12 roundTripHFPlaceholder12 = (RoundTripHFPlaceholder12)this.getClientDataRecord(RecordTypes.RoundTripHFPlaceholder12.typeID);
        return roundTripHFPlaceholder12 != null;
    }

    @Override
    public Iterator<HSLFTextParagraph> iterator() {
        return this._paragraphs.iterator();
    }

    @Override
    public Insets2D getInsets() {
        Insets2D insets2D = new Insets2D(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
        return insets2D;
    }

    @Override
    public double getTextHeight() {
        DrawFactory drawFactory = DrawFactory.getInstance(null);
        DrawTextShape drawTextShape = drawFactory.getDrawable(this);
        return drawTextShape.getTextHeight();
    }

    @Override
    public TextShape.TextDirection getTextDirection() {
        return TextShape.TextDirection.HORIZONTAL;
    }

    public String getRawText() {
        return HSLFTextParagraph.getRawText(this.getTextParagraphs());
    }

    public String getText() {
        String string = this.getRawText();
        return HSLFTextParagraph.toExternalString(string, this.getRunType());
    }

    public HSLFTextRun appendText(String string, boolean bl) {
        List<HSLFTextParagraph> list = this.getTextParagraphs();
        return HSLFTextParagraph.appendText(list, string, bl);
    }

    public HSLFTextRun setText(String string) {
        List<HSLFTextParagraph> list = this.getTextParagraphs();
        HSLFTextRun hSLFTextRun = HSLFTextParagraph.setText(list, string);
        this.setTextId(string.hashCode());
        return hSLFTextRun;
    }

    protected void storeText() {
        List<HSLFTextParagraph> list = this.getTextParagraphs();
        HSLFTextParagraph.storeText(list);
    }

    public List<HSLFHyperlink> getHyperlinks() {
        return HSLFHyperlink.find(this);
    }
}

