/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.record.CurrentUserAtom;
import ai2.org.apache.poi.hslf.record.DocumentEncryptionAtom;
import ai2.org.apache.poi.hslf.record.ExOleObjStg;
import ai2.org.apache.poi.hslf.record.PersistPtrHolder;
import ai2.org.apache.poi.hslf.record.PersistRecord;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.UserEditAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFObjectData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowEncrypted;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.EntryUtils;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFSlideShowImpl
extends POIDocument {
    public static final int UNSET_OFFSET = -1;
    private POILogger logger = POILogFactory.getLogger(this.getClass());
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private List<HSLFPictureData> _pictures;
    private HSLFObjectData[] _objects;

    protected DirectoryNode getPOIFSDirectory() {
        return this.directory;
    }

    public HSLFSlideShowImpl(String string) throws IOException {
        this(new POIFSFileSystem(new File(string)));
    }

    public HSLFSlideShowImpl(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public HSLFSlideShowImpl(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public HSLFSlideShowImpl(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    @Deprecated
    public HSLFSlideShowImpl(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public HSLFSlideShowImpl(DirectoryNode directoryNode) throws IOException {
        super(HSLFSlideShowImpl.handleDualStorage(directoryNode));
        this.readCurrentUserStream();
        this.readPowerPointStream();
        this.buildRecords();
        this.readOtherStreams();
    }

    private static DirectoryNode handleDualStorage(DirectoryNode directoryNode) throws IOException {
        String string = "PP97_DUALSTORAGE";
        if (!directoryNode.hasEntry(string)) {
            return directoryNode;
        }
        directoryNode = (DirectoryNode)directoryNode.getEntry(string);
        return directoryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HSLFSlideShowImpl create() {
        HSLFSlideShowImpl hSLFSlideShowImpl;
        InputStream inputStream = HSLFSlideShowImpl.class.getResourceAsStream("/ai2.org.apache.poi/hslf/data/empty.ppt");
        if (inputStream == null) {
            throw new HSLFException("Missing resource 'empty.ppt'");
        }
        try {
            hSLFSlideShowImpl = new HSLFSlideShowImpl(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new HSLFException(iOException);
            }
        }
        inputStream.close();
        return hSLFSlideShowImpl;
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)this.directory.getEntry("PowerPoint Document");
        this._docstream = new byte[documentEntry.getSize()];
        this.directory.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    private void buildRecords() {
        this._records = this.read(this._docstream, (int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(byte[] byArray, int n) {
        TreeMap<Integer, Record> treeMap = new TreeMap<Integer, Record>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        this.initRecordOffsets(byArray, n, treeMap, hashMap);
        HSLFSlideShowEncrypted hSLFSlideShowEncrypted = new HSLFSlideShowEncrypted(byArray, treeMap);
        for (Map.Entry entry : treeMap.entrySet()) {
            Integer n2 = (Integer)entry.getKey();
            Record record = (Record)entry.getValue();
            Integer n3 = (Integer)hashMap.get(n2);
            if (record == null) {
                hSLFSlideShowEncrypted.decryptRecord(byArray, n3, n2);
                record = Record.buildRecordAtOffset(byArray, n2);
                entry.setValue(record);
            }
            if (!(record instanceof PersistRecord)) continue;
            ((PersistRecord)((Object)record)).setPersistId(n3);
        }
        return treeMap.values().toArray(new Record[treeMap.size()]);
    }

    private void initRecordOffsets(byte[] byArray, int n, NavigableMap<Integer, Record> navigableMap, Map<Integer, Integer> map) {
        while (n != 0) {
            UserEditAtom userEditAtom = (UserEditAtom)Record.buildRecordAtOffset(byArray, n);
            navigableMap.put(n, userEditAtom);
            int n2 = userEditAtom.getPersistPointersOffset();
            PersistPtrHolder persistPtrHolder = (PersistPtrHolder)Record.buildRecordAtOffset(byArray, n2);
            navigableMap.put(n2, persistPtrHolder);
            for (Map.Entry<Integer, Integer> entry : persistPtrHolder.getSlideLocationsLookup().entrySet()) {
                Integer n3 = entry.getValue();
                Integer n4 = entry.getKey();
                navigableMap.put(n3, null);
                map.put(n3, n4);
            }
            n = userEditAtom.getLastUserEditAtomOffset();
            if (n <= 0 || !navigableMap.containsKey(n)) continue;
            n = (Integer)navigableMap.firstKey() - 36;
            int n5 = LittleEndian.getUShort(byArray, n);
            int n6 = LittleEndian.getUShort(byArray, n + 2);
            int n7 = LittleEndian.getInt(byArray, n + 4);
            if (n5 == 0 && n6 == 4085 && (n7 == 28 || n7 == 32)) {
                this.logger.log(5, new Object[]{"Repairing invalid user edit atom"});
                userEditAtom.setLastUserEditAtomOffset(n);
                continue;
            }
            throw new CorruptPowerPointFileException("Powerpoint document contains invalid user edit atom");
        }
    }

    public DocumentEncryptionAtom getDocumentEncryptionAtom() {
        for (Record record : this._records) {
            if (!(record instanceof DocumentEncryptionAtom)) continue;
            return (DocumentEncryptionAtom)record;
        }
        return null;
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.directory);
        }
        catch (IOException iOException) {
            this.logger.log(7, new Object[]{"Error finding Current User Atom:\n" + iOException});
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        int n;
        this._pictures = new ArrayList<HSLFPictureData>();
        if (!this.directory.hasEntry("Pictures")) {
            return;
        }
        HSLFSlideShowEncrypted hSLFSlideShowEncrypted = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        DocumentEntry documentEntry = (DocumentEntry)this.directory.getEntry("Pictures");
        byte[] byArray = new byte[documentEntry.getSize()];
        DocumentInputStream documentInputStream = this.directory.createDocumentInputStream(documentEntry);
        documentInputStream.read(byArray);
        documentInputStream.close();
        for (int i = 0; i <= byArray.length - 8; i += n) {
            int n2 = i;
            hSLFSlideShowEncrypted.decryptPicture(byArray, n2);
            int n3 = LittleEndian.getUShort(byArray, i);
            int n4 = LittleEndian.getUShort(byArray, i += 2);
            n = LittleEndian.getInt(byArray, i += 2);
            i += 4;
            if (n4 != 61447 && (n4 < 61464 || n4 > 61719)) break;
            if (n < 0) {
                throw new CorruptPowerPointFileException("The file contains a picture, at position " + this._pictures.size() + ", which has a negatively sized data length, so we can't trust any of the picture data");
            }
            PictureData.PictureType pictureType = PictureData.PictureType.forNativeID(n4 - 61464);
            if (n4 == 0 || pictureType == null) {
                this.logger.log(7, new Object[]{"Problem reading picture: Invalid image type 0, on picture with length " + n + ".\nYou document will probably become corrupted if you save it!"});
                this.logger.log(7, new Object[]{"" + i});
                continue;
            }
            try {
                HSLFPictureData hSLFPictureData = HSLFPictureData.create(pictureType);
                hSLFPictureData.setSignature(n3);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, i, byArray2, 0, byArray2.length);
                hSLFPictureData.setRawData(byArray2);
                hSLFPictureData.setOffset(n2);
                hSLFPictureData.setIndex(this._pictures.size());
                this._pictures.add(hSLFPictureData);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(7, new Object[]{"Problem reading picture: " + illegalArgumentException + "\nYou document will probably become corrupted if you save it!"});
            }
        }
    }

    public void normalizeRecords() {
        try {
            this.updateAndWriteDependantRecords(null, null);
        }
        catch (IOException iOException) {
            throw new CorruptPowerPointFileException(iOException);
        }
        this._records = HSLFSlideShowEncrypted.normalizeRecords(this._records);
    }

    public void updateAndWriteDependantRecords(OutputStream outputStream, Map<RecordTypes.Type, PositionDependentRecord> map) throws IOException {
        Object object;
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        UserEditAtom userEditAtom = null;
        PersistPtrHolder persistPtrHolder = null;
        CountingOS countingOS = new CountingOS();
        for (Record record : this._records) {
            assert (record instanceof PositionDependentRecord);
            PositionDependentRecord positionDependentRecord = (PositionDependentRecord)((Object)record);
            int n = positionDependentRecord.getLastOnDiskOffset();
            int n2 = countingOS.size();
            positionDependentRecord.setLastOnDiskOffset(n2);
            if (n != -1) {
                hashtable.put(n, n2);
            }
            object = null;
            int n3 = (int)record.getRecordType();
            if (n3 == RecordTypes.PersistPtrIncrementalBlock.typeID) {
                object = RecordTypes.PersistPtrIncrementalBlock;
                persistPtrHolder = (PersistPtrHolder)positionDependentRecord;
            } else if (n3 == RecordTypes.UserEditAtom.typeID) {
                object = RecordTypes.UserEditAtom;
                userEditAtom = (UserEditAtom)positionDependentRecord;
            }
            if (map != null && object != null) {
                map.put((RecordTypes.Type)object, positionDependentRecord);
            }
            record.writeOut(countingOS);
        }
        countingOS.close();
        assert (userEditAtom != null && persistPtrHolder != null);
        HashMap hashMap = new HashMap();
        for (Map.Entry<Integer, Integer> entry : persistPtrHolder.getSlideLocationsLookup().entrySet()) {
            hashMap.put(hashtable.get(entry.getValue()), entry.getKey());
        }
        HSLFSlideShowEncrypted hSLFSlideShowEncrypted = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        for (Record record : this._records) {
            assert (record instanceof PositionDependentRecord);
            PositionDependentRecord positionDependentRecord = (PositionDependentRecord)((Object)record);
            object = (Integer)hashMap.get(positionDependentRecord.getLastOnDiskOffset());
            if (object == null) {
                object = 0;
            }
            positionDependentRecord.updateOtherRecordReferences(hashtable);
            if (outputStream == null) continue;
            record.writeOut(hSLFSlideShowEncrypted.encryptRecord(outputStream, (Integer)object, record));
        }
        int n = (int)this.currentUser.getCurrentEditOffset();
        Integer n4 = (Integer)hashtable.get(n);
        if (userEditAtom == null || n4 == null || userEditAtom.getLastOnDiskOffset() != n4.intValue()) {
            throw new HSLFException("Couldn't find the new location of the last UserEditAtom that used to be at " + n);
        }
        this.currentUser.setCurrentEditOffset(userEditAtom.getLastOnDiskOffset());
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, false);
    }

    public void write(OutputStream outputStream, boolean bl) throws IOException {
        if (this._pictures == null) {
            this.readPictures();
        }
        this.getDocumentSummaryInformation();
        HSLFSlideShowEncrypted hSLFSlideShowEncrypted = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        this._records = hSLFSlideShowEncrypted.updateEncryptionRecord(this._records);
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        this.writeProperties(pOIFSFileSystem, arrayList);
        BufAccessBAOS bufAccessBAOS = new BufAccessBAOS();
        this.updateAndWriteDependantRecords(bufAccessBAOS, null);
        this._docstream = new byte[bufAccessBAOS.size()];
        System.arraycopy(bufAccessBAOS.getBuf(), 0, this._docstream, 0, bufAccessBAOS.size());
        bufAccessBAOS.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._docstream);
        pOIFSFileSystem.createDocument(byteArrayInputStream, "PowerPoint Document");
        arrayList.add("PowerPoint Document");
        this.currentUser.setEncrypted(hSLFSlideShowEncrypted.getDocumentEncryptionAtom() != null);
        this.currentUser.writeToFS(pOIFSFileSystem);
        arrayList.add("Current User");
        if (this._pictures.size() > 0) {
            BufAccessBAOS bufAccessBAOS2 = new BufAccessBAOS();
            for (HSLFPictureData hSLFPictureData : this._pictures) {
                int n = bufAccessBAOS2.size();
                hSLFPictureData.write(bufAccessBAOS2);
                hSLFSlideShowEncrypted.encryptPicture(bufAccessBAOS2.getBuf(), n);
            }
            pOIFSFileSystem.createDocument(new ByteArrayInputStream(bufAccessBAOS2.getBuf(), 0, bufAccessBAOS2.size()), "Pictures");
            arrayList.add("Pictures");
            bufAccessBAOS2.close();
        }
        if (bl) {
            EntryUtils.copyNodes(this.directory.getFileSystem(), pOIFSFileSystem, arrayList);
        }
        pOIFSFileSystem.writeFilesystem(outputStream);
        pOIFSFileSystem.close();
    }

    @Override
    protected PropertySet getPropertySet(String string) {
        DocumentEncryptionAtom documentEncryptionAtom = this.getDocumentEncryptionAtom();
        return documentEncryptionAtom == null ? super.getPropertySet(string) : super.getPropertySet(string, documentEncryptionAtom.getEncryptionInfo());
    }

    protected void writeProperties(POIFSFileSystem pOIFSFileSystem, List<String> list) throws IOException {
        super.writeProperties(pOIFSFileSystem, list);
        DocumentEncryptionAtom documentEncryptionAtom = this.getDocumentEncryptionAtom();
        if (documentEncryptionAtom != null) {
            CryptoAPIEncryptor cryptoAPIEncryptor = (CryptoAPIEncryptor)documentEncryptionAtom.getEncryptionInfo().getEncryptor();
            try {
                cryptoAPIEncryptor.getDataStream(pOIFSFileSystem.getRoot());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
    }

    public synchronized int appendRootLevelRecord(Record record) {
        int n = -1;
        Record[] recordArray = new Record[this._records.length + 1];
        boolean bl = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (bl) {
                recordArray[i] = this._records[i];
                continue;
            }
            recordArray[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            recordArray[i] = record;
            bl = true;
            n = i;
        }
        this._records = recordArray;
        return n;
    }

    public int addPicture(HSLFPictureData hSLFPictureData) {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException iOException) {
                throw new CorruptPowerPointFileException(iOException.getMessage());
            }
        }
        int n = 0;
        if (this._pictures.size() > 0) {
            HSLFPictureData hSLFPictureData2 = this._pictures.get(this._pictures.size() - 1);
            n = hSLFPictureData2.getOffset() + hSLFPictureData2.getRawData().length + 8;
        }
        hSLFPictureData.setOffset(n);
        hSLFPictureData.setIndex(this._pictures.size() + 1);
        this._pictures.add(hSLFPictureData);
        return n;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public List<HSLFPictureData> getPictureData() {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException iOException) {
                throw new CorruptPowerPointFileException(iOException.getMessage());
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public HSLFObjectData[] getEmbeddedObjects() {
        if (this._objects == null) {
            ArrayList<HSLFObjectData> arrayList = new ArrayList<HSLFObjectData>();
            for (Record record : this._records) {
                if (!(record instanceof ExOleObjStg)) continue;
                arrayList.add(new HSLFObjectData((ExOleObjStg)record));
            }
            this._objects = arrayList.toArray(new HSLFObjectData[arrayList.size()]);
        }
        return this._objects;
    }

    private static class CountingOS
    extends OutputStream {
        int count = 0;

        private CountingOS() {
        }

        public void write(int n) throws IOException {
            ++this.count;
        }

        public void write(byte[] byArray) throws IOException {
            this.count += byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.count += n2;
        }

        public int size() {
            return this.count;
        }
    }

    private static class BufAccessBAOS
    extends ByteArrayOutputStream {
        private BufAccessBAOS() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

