/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.record.MainMaster;
import ai2.org.apache.poi.hslf.record.TxMasterStyleAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFSlideMaster
extends HSLFMasterSheet {
    private final List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();
    private TxMasterStyleAtom[] _txmaster;

    public HSLFSlideMaster(MainMaster mainMaster, int n) {
        super(mainMaster, n);
        for (List<HSLFTextParagraph> list : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(list)) continue;
            this._paragraphs.add(list);
        }
        for (List<HSLFTextParagraph> list : this._paragraphs) {
            for (HSLFTextParagraph hSLFTextParagraph : list) {
                hSLFTextParagraph.supplySheet(this);
            }
        }
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        return null;
    }

    @Override
    public TextProp getStyleAttribute(int n, int n2, String string, boolean bl) {
        if (this._txmaster.length <= n) {
            return null;
        }
        TxMasterStyleAtom txMasterStyleAtom = this._txmaster[n];
        List<TextPropCollection> list = bl ? txMasterStyleAtom.getCharacterStyles() : txMasterStyleAtom.getParagraphStyles();
        TextProp textProp = null;
        for (int i = Math.min(n2, list.size() - 1); textProp == null && i >= 0; --i) {
            textProp = list.get(i).findByName(string);
        }
        if (textProp != null) {
            return textProp;
        }
        switch (n) {
            case 5: 
            case 7: 
            case 8: {
                n = 1;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getStyleAttribute(n, n2, string, bl);
    }

    @Override
    public void setSlideShow(HSLFSlideShow hSLFSlideShow) {
        super.setSlideShow(hSLFSlideShow);
        if (this._txmaster == null) {
            TxMasterStyleAtom txMasterStyleAtom;
            this._txmaster = new TxMasterStyleAtom[9];
            this._txmaster[txMasterStyleAtom.getTextType()] = txMasterStyleAtom = this.getSlideShow().getDocumentRecord().getEnvironment().getTxMasterStyleAtom();
            TxMasterStyleAtom[] txMasterStyleAtomArray = ((MainMaster)this.getSheetContainer()).getTxMasterStyleAtoms();
            for (int i = 0; i < txMasterStyleAtomArray.length; ++i) {
                int n = txMasterStyleAtomArray[i].getTextType();
                if (this._txmaster[n] != null) continue;
                this._txmaster[n] = txMasterStyleAtomArray[i];
            }
        }
    }

    @Override
    protected void onAddTextShape(HSLFTextShape hSLFTextShape) {
        List<HSLFTextParagraph> list = hSLFTextShape.getTextParagraphs();
        this._paragraphs.add(list);
    }

    public TxMasterStyleAtom[] getTxMasterStyleAtoms() {
        return this._txmaster;
    }
}

