/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherPropertyFactory;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.model.MovieShape;
import ai2.org.apache.poi.hslf.model.OLEShape;
import ai2.org.apache.poi.hslf.record.InteractiveInfo;
import ai2.org.apache.poi.hslf.record.OEShapeAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFLine;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTable;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFShapeFactory {
    protected static final POILogger logger = POILogFactory.getLogger(HSLFShapeFactory.class);

    public static HSLFShape createShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        if (escherContainerRecord.getRecordId() == -4093) {
            return HSLFShapeFactory.createShapeGroup(escherContainerRecord, shapeContainer);
        }
        return HSLFShapeFactory.createSimpleShape(escherContainerRecord, shapeContainer);
    }

    public static HSLFGroupShape createShapeGroup(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        Object object;
        boolean bl = false;
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)escherContainerRecord.getChild(0);
        Object t = HSLFShape.getEscherChild(escherContainerRecord2, -3806);
        if (t != null) {
            object = new EscherPropertyFactory();
            List<EscherProperty> list = ((EscherPropertyFactory)object).createProperties(((EscherRecord)t).serialize(), 8, ((EscherRecord)t).getInstance());
            for (EscherProperty escherProperty : list) {
                if (escherProperty.getPropertyNumber() != 927 || !(escherProperty instanceof EscherSimpleProperty) || ((EscherSimpleProperty)escherProperty).getPropertyValue() != 1) continue;
                bl = true;
                break;
            }
        }
        object = bl ? new HSLFTable(escherContainerRecord, shapeContainer) : new HSLFGroupShape(escherContainerRecord, shapeContainer);
        return object;
    }

    public static HSLFShape createSimpleShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        HSLFSimpleShape hSLFSimpleShape = null;
        EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086);
        ShapeType shapeType = ShapeType.forId(escherSpRecord.getShapeType(), false);
        switch (shapeType) {
            case TEXT_BOX: {
                hSLFSimpleShape = new HSLFTextBox(escherContainerRecord, shapeContainer);
                break;
            }
            case HOST_CONTROL: 
            case FRAME: {
                InteractiveInfo interactiveInfo = (InteractiveInfo)HSLFShapeFactory.getClientDataRecord(escherContainerRecord, RecordTypes.InteractiveInfo.typeID);
                OEShapeAtom oEShapeAtom = (OEShapeAtom)HSLFShapeFactory.getClientDataRecord(escherContainerRecord, RecordTypes.OEShapeAtom.typeID);
                if (interactiveInfo != null && interactiveInfo.getInteractiveInfoAtom() != null) {
                    switch (interactiveInfo.getInteractiveInfoAtom().getAction()) {
                        case 5: {
                            hSLFSimpleShape = new OLEShape(escherContainerRecord, shapeContainer);
                            break;
                        }
                        case 6: {
                            hSLFSimpleShape = new MovieShape(escherContainerRecord, shapeContainer);
                            break;
                        }
                    }
                } else if (oEShapeAtom != null) {
                    hSLFSimpleShape = new OLEShape(escherContainerRecord, shapeContainer);
                }
                if (hSLFSimpleShape != null) break;
                hSLFSimpleShape = new HSLFPictureShape(escherContainerRecord, shapeContainer);
                break;
            }
            case LINE: {
                hSLFSimpleShape = new HSLFLine(escherContainerRecord, shapeContainer);
                break;
            }
            case NOT_PRIMITIVE: {
                AbstractEscherOptRecord abstractEscherOptRecord = (AbstractEscherOptRecord)HSLFShape.getEscherChild(escherContainerRecord, -4085);
                Object t = HSLFShape.getEscherProperty(abstractEscherOptRecord, 325);
                if (t != null) {
                    hSLFSimpleShape = new HSLFFreeformShape(escherContainerRecord, shapeContainer);
                    break;
                }
                logger.log(3, new Object[]{"Creating AutoShape for a NotPrimitive shape"});
                hSLFSimpleShape = new HSLFAutoShape(escherContainerRecord, shapeContainer);
                break;
            }
            default: {
                hSLFSimpleShape = new HSLFAutoShape(escherContainerRecord, shapeContainer);
            }
        }
        return hSLFSimpleShape;
    }

    protected static <T extends Record> T getClientDataRecord(EscherContainerRecord escherContainerRecord, int n) {
        T t = null;
        Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != -4079) continue;
            byte[] byArray = escherRecord.serialize();
            Record[] recordArray = Record.findChildRecords(byArray, 8, byArray.length - 8);
            for (int i = 0; i < recordArray.length; ++i) {
                if (recordArray[i].getRecordType() != (long)n) continue;
                return (T)recordArray[i];
            }
        }
        return t;
    }
}

