/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.draw.DrawPictureShape;
import ai2.org.apache.poi.sl.usermodel.PictureShape;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.StringUtil;
import ai2.org.apache.poi.util.Units;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSLFPictureShape
extends HSLFSimpleShape
implements PictureShape<HSLFShape, HSLFTextParagraph> {
    public HSLFPictureShape(HSLFPictureData hSLFPictureData) {
        this(hSLFPictureData, null);
    }

    public HSLFPictureShape(HSLFPictureData hSLFPictureData, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(null, shapeContainer);
        this._escherContainer = this.createSpContainer(hSLFPictureData.getIndex(), shapeContainer instanceof HSLFGroupShape);
    }

    protected HSLFPictureShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public int getPictureIndex() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFPictureShape.getEscherProperty(abstractEscherOptRecord, 260);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    protected EscherContainerRecord createSpContainer(int n, boolean bl) {
        this._escherContainer = super.createSpContainer(bl);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord escherSpRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        escherSpRecord.setOptions((short)(ShapeType.FRAME.nativeId << 4 | 2));
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFPictureShape.setEscherProperty(abstractEscherOptRecord, (short)127, 0x800080);
        HSLFPictureShape.setEscherProperty(abstractEscherOptRecord, (short)16644, n);
        return this._escherContainer;
    }

    @Override
    public HSLFPictureData getPictureData() {
        HSLFSlideShow hSLFSlideShow = this.getSheet().getSlideShow();
        List<HSLFPictureData> list = hSLFSlideShow.getPictureData();
        EscherBSERecord escherBSERecord = this.getEscherBSERecord();
        if (escherBSERecord == null) {
            this.logger.log(7, new Object[]{"no reference to picture data found "});
        } else {
            for (HSLFPictureData hSLFPictureData : list) {
                if (hSLFPictureData.getOffset() != escherBSERecord.getOffset()) continue;
                return hSLFPictureData;
            }
            this.logger.log(7, new Object[]{"no picture found for our BSE offset " + escherBSERecord.getOffset()});
        }
        return null;
    }

    protected EscherBSERecord getEscherBSERecord() {
        HSLFSlideShow hSLFSlideShow = this.getSheet().getSlideShow();
        Document document = hSLFSlideShow.getDocumentRecord();
        EscherContainerRecord escherContainerRecord = document.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)HSLFShape.getEscherChild(escherContainerRecord, -4095);
        if (escherContainerRecord2 == null) {
            this.logger.log(1, new Object[]{"EscherContainerRecord.BSTORE_CONTAINER was not found "});
            return null;
        }
        List<EscherRecord> list = escherContainerRecord2.getChildRecords();
        int n = this.getPictureIndex();
        if (n == 0) {
            this.logger.log(1, new Object[]{"picture index was not found, returning "});
            return null;
        }
        return (EscherBSERecord)list.get(n - 1);
    }

    public String getPictureName() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)HSLFPictureShape.getEscherProperty(abstractEscherOptRecord, 261);
        if (escherComplexProperty == null) {
            return null;
        }
        String string = StringUtil.getFromUnicodeLE(escherComplexProperty.getComplexData());
        return string.trim();
    }

    public void setPictureName(String string) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        byte[] byArray = StringUtil.getToUnicodeLE(string + '\u0000');
        EscherComplexProperty escherComplexProperty = new EscherComplexProperty(261, false, byArray);
        abstractEscherOptRecord.addEscherProperty(escherComplexProperty);
    }

    @Override
    protected void afterInsert(HSLFSheet hSLFSheet) {
        super.afterInsert(hSLFSheet);
        EscherBSERecord escherBSERecord = this.getEscherBSERecord();
        escherBSERecord.setRef(escherBSERecord.getRef() + 1);
        Rectangle rectangle = this.getAnchor();
        if (rectangle.isEmpty()) {
            new DrawPictureShape(this).resize();
        }
    }

    @Override
    public Insets getClipping() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        double d = HSLFPictureShape.getFractProp(abstractEscherOptRecord, (short)256);
        double d2 = HSLFPictureShape.getFractProp(abstractEscherOptRecord, (short)257);
        double d3 = HSLFPictureShape.getFractProp(abstractEscherOptRecord, (short)258);
        double d4 = HSLFPictureShape.getFractProp(abstractEscherOptRecord, (short)259);
        return d == 0.0 && d2 == 0.0 && d3 == 0.0 && d4 == 0.0 ? null : new Insets((int)(d * 100000.0), (int)(d3 * 100000.0), (int)(d2 * 100000.0), (int)(d4 * 100000.0));
    }

    private static double getFractProp(AbstractEscherOptRecord abstractEscherOptRecord, short s) {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFPictureShape.getEscherProperty(abstractEscherOptRecord, s);
        if (escherSimpleProperty == null) {
            return 0.0;
        }
        int n = escherSimpleProperty.getPropertyValue();
        return Units.fixedPointToDouble(n);
    }
}

