/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSpgrRecord;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFConnectorShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFHyperlink;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShapeContainer;
import ai2.org.apache.poi.hslf.usermodel.HSLFShapeFactory;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTable;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.GroupShape;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSLFGroupShape
extends HSLFShape
implements HSLFShapeContainer,
GroupShape<HSLFShape, HSLFTextParagraph> {
    public HSLFGroupShape() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    public HSLFGroupShape(ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        this(null, shapeContainer);
        this._escherContainer = this.createSpContainer(shapeContainer instanceof HSLFGroupShape);
    }

    protected HSLFGroupShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    @Override
    public void setAnchor(Rectangle rectangle) {
        EscherClientAnchorRecord escherClientAnchorRecord = (EscherClientAnchorRecord)this.getEscherChild(-4080);
        byte[] byArray = new byte[16];
        LittleEndian.putUShort(byArray, 0, 0);
        LittleEndian.putUShort(byArray, 2, 0);
        LittleEndian.putInt(byArray, 4, 8);
        escherClientAnchorRecord.fillFields(byArray, 0, null);
        escherClientAnchorRecord.setFlag((short)Units.pointsToMaster(rectangle.y));
        escherClientAnchorRecord.setCol1((short)Units.pointsToMaster(rectangle.x));
        escherClientAnchorRecord.setDx1((short)Units.pointsToMaster(rectangle.width + rectangle.x));
        escherClientAnchorRecord.setRow1((short)Units.pointsToMaster(rectangle.height + rectangle.y));
        EscherSpgrRecord escherSpgrRecord = (EscherSpgrRecord)this.getEscherChild(-4087);
        escherSpgrRecord.setRectX1(Units.pointsToMaster(rectangle.x));
        escherSpgrRecord.setRectY1(Units.pointsToMaster(rectangle.y));
        escherSpgrRecord.setRectX2(Units.pointsToMaster(rectangle.x + rectangle.width));
        escherSpgrRecord.setRectY2(Units.pointsToMaster(rectangle.y + rectangle.height));
    }

    @Override
    public void setInteriorAnchor(Rectangle rectangle) {
        EscherSpgrRecord escherSpgrRecord = (EscherSpgrRecord)this.getEscherChild(-4087);
        int n = Units.pointsToMaster(rectangle.getX());
        int n2 = Units.pointsToMaster(rectangle.getY());
        int n3 = Units.pointsToMaster(rectangle.getX() + rectangle.getWidth());
        int n4 = Units.pointsToMaster(rectangle.getY() + rectangle.getHeight());
        escherSpgrRecord.setRectX1(n);
        escherSpgrRecord.setRectY1(n2);
        escherSpgrRecord.setRectX2(n3);
        escherSpgrRecord.setRectY2(n4);
    }

    @Override
    public Rectangle getInteriorAnchor() {
        EscherSpgrRecord escherSpgrRecord = (EscherSpgrRecord)this.getEscherChild(-4087);
        int n = (int)Units.masterToPoints(escherSpgrRecord.getRectX1());
        int n2 = (int)Units.masterToPoints(escherSpgrRecord.getRectY1());
        int n3 = (int)Units.masterToPoints(escherSpgrRecord.getRectX2());
        int n4 = (int)Units.masterToPoints(escherSpgrRecord.getRectY2());
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean bl) {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        escherContainerRecord.setRecordId((short)-4093);
        escherContainerRecord.setOptions((short)15);
        EscherContainerRecord escherContainerRecord2 = new EscherContainerRecord();
        escherContainerRecord2.setRecordId((short)-4092);
        escherContainerRecord2.setOptions((short)15);
        EscherSpgrRecord escherSpgrRecord = new EscherSpgrRecord();
        escherSpgrRecord.setOptions((short)1);
        escherContainerRecord2.addChildRecord(escherSpgrRecord);
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        short s = (short)((ShapeType.NOT_PRIMITIVE.nativeId << 4) + 2);
        escherSpRecord.setOptions(s);
        escherSpRecord.setFlags(513);
        escherContainerRecord2.addChildRecord(escherSpRecord);
        EscherClientAnchorRecord escherClientAnchorRecord = new EscherClientAnchorRecord();
        escherContainerRecord2.addChildRecord(escherClientAnchorRecord);
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        return escherContainerRecord;
    }

    @Override
    public void addShape(HSLFShape hSLFShape) {
        this._escherContainer.addChildRecord(hSLFShape.getSpContainer());
        HSLFSheet hSLFSheet = this.getSheet();
        hSLFShape.setSheet(hSLFSheet);
        hSLFShape.setShapeId(hSLFSheet.allocateShapeId());
        hSLFShape.afterInsert(hSLFSheet);
    }

    public void moveTo(int n, int n2) {
        Rectangle rectangle = this.getAnchor();
        int n3 = n - rectangle.x;
        int n4 = n2 - rectangle.y;
        rectangle.translate(n3, n4);
        this.setAnchor(rectangle);
        for (HSLFShape hSLFShape : this.getShapes()) {
            Rectangle rectangle2 = hSLFShape.getAnchor();
            rectangle2.translate(n3, n4);
            hSLFShape.setAnchor(rectangle2);
        }
    }

    @Override
    public Rectangle getAnchor() {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        EscherClientAnchorRecord escherClientAnchorRecord = (EscherClientAnchorRecord)this.getEscherChild(-4080);
        if (escherClientAnchorRecord == null) {
            this.logger.log(3, new Object[]{"EscherClientAnchorRecord was not found for shape group. Searching for EscherChildAnchorRecord."});
            object = (EscherChildAnchorRecord)this.getEscherChild(-4081);
            n4 = ((EscherChildAnchorRecord)object).getDx1();
            n3 = ((EscherChildAnchorRecord)object).getDy1();
            n2 = ((EscherChildAnchorRecord)object).getDx2();
            n = ((EscherChildAnchorRecord)object).getDy2();
        } else {
            n4 = escherClientAnchorRecord.getCol1();
            n3 = escherClientAnchorRecord.getFlag();
            n2 = escherClientAnchorRecord.getDx1();
            n = escherClientAnchorRecord.getRow1();
        }
        object = new Rectangle((int)(n4 == -1 ? -1.0 : Units.masterToPoints(n4)), (int)(n3 == -1 ? -1.0 : Units.masterToPoints(n3)), (int)(n2 == -1 ? -1.0 : Units.masterToPoints(n2 - n4)), (int)(n == -1 ? -1.0 : Units.masterToPoints(n - n3)));
        return object;
    }

    @Override
    public ShapeType getShapeType() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int n = escherSpRecord.getOptions() >> 4;
        return ShapeType.forId(n, false);
    }

    @Override
    public HSLFHyperlink getHyperlink() {
        return null;
    }

    @Override
    public <T extends EscherRecord> T getEscherChild(int n) {
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this._escherContainer.getChild(0);
        return escherContainerRecord.getChildById((short)n);
    }

    @Override
    public Iterator<HSLFShape> iterator() {
        return this.getShapes().iterator();
    }

    @Override
    public boolean removeShape(HSLFShape hSLFShape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HSLFShape> getShapes() {
        Iterator<EscherRecord> iterator = this._escherContainer.getChildIterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        ArrayList<HSLFShape> arrayList = new ArrayList<HSLFShape>();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord instanceof EscherContainerRecord) {
                EscherContainerRecord escherContainerRecord = (EscherContainerRecord)escherRecord;
                HSLFShape hSLFShape = HSLFShapeFactory.createShape(escherContainerRecord, this);
                hSLFShape.setSheet(this.getSheet());
                arrayList.add(hSLFShape);
                continue;
            }
            this.logger.log(7, new Object[]{"Shape contained non container escher record, was " + escherRecord.getClass().getName()});
        }
        return arrayList;
    }

    @Override
    public HSLFTextBox createTextBox() {
        HSLFTextBox hSLFTextBox = new HSLFTextBox(this);
        hSLFTextBox.setHorizontalCentered(true);
        hSLFTextBox.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFTextBox);
        return hSLFTextBox;
    }

    @Override
    public HSLFAutoShape createAutoShape() {
        HSLFAutoShape hSLFAutoShape = new HSLFAutoShape(ShapeType.RECT, (ShapeContainer<HSLFShape, HSLFTextParagraph>)this);
        hSLFAutoShape.setHorizontalCentered(true);
        hSLFAutoShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFAutoShape);
        return hSLFAutoShape;
    }

    @Override
    public HSLFFreeformShape createFreeform() {
        HSLFFreeformShape hSLFFreeformShape = new HSLFFreeformShape(this);
        hSLFFreeformShape.setHorizontalCentered(true);
        hSLFFreeformShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFFreeformShape);
        return hSLFFreeformShape;
    }

    @Override
    public HSLFConnectorShape createConnector() {
        HSLFConnectorShape hSLFConnectorShape = new HSLFConnectorShape(this);
        hSLFConnectorShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFConnectorShape);
        return hSLFConnectorShape;
    }

    @Override
    public HSLFGroupShape createGroup() {
        HSLFGroupShape hSLFGroupShape = new HSLFGroupShape(this);
        hSLFGroupShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFGroupShape);
        return hSLFGroupShape;
    }

    @Override
    public HSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof HSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type HSLFPictureData");
        }
        HSLFPictureShape hSLFPictureShape = new HSLFPictureShape((HSLFPictureData)pictureData, (ShapeContainer<HSLFShape, HSLFTextParagraph>)this);
        hSLFPictureShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFPictureShape);
        return hSLFPictureShape;
    }

    public HSLFTable createTable(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        HSLFTable hSLFTable = new HSLFTable(n, n2, this);
        hSLFTable.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFTable);
        return hSLFTable;
    }
}

