/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.PositionDependentRecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserEditAtom
extends PositionDependentRecordAtom {
    public static final int LAST_VIEW_NONE = 0;
    public static final int LAST_VIEW_SLIDE_VIEW = 1;
    public static final int LAST_VIEW_OUTLINE_VIEW = 2;
    public static final int LAST_VIEW_NOTES = 3;
    private byte[] _header;
    private static long _type = 4085L;
    private short unused;
    private int lastViewedSlideID;
    private int pptVersion;
    private int lastUserEditAtomOffset;
    private int persistPointersOffset;
    private int docPersistRef;
    private int maxPersistWritten;
    private short lastViewType;
    private int encryptSessionPersistIdRef = -1;

    public int getLastViewedSlideID() {
        return this.lastViewedSlideID;
    }

    public short getLastViewType() {
        return this.lastViewType;
    }

    public int getLastUserEditAtomOffset() {
        return this.lastUserEditAtomOffset;
    }

    public int getPersistPointersOffset() {
        return this.persistPointersOffset;
    }

    public int getDocPersistRef() {
        return this.docPersistRef;
    }

    public int getMaxPersistWritten() {
        return this.maxPersistWritten;
    }

    public int getEncryptSessionPersistIdRef() {
        return this.encryptSessionPersistIdRef;
    }

    public void setLastUserEditAtomOffset(int n) {
        this.lastUserEditAtomOffset = n;
    }

    public void setPersistPointersOffset(int n) {
        this.persistPointersOffset = n;
    }

    public void setLastViewType(short s) {
        this.lastViewType = s;
    }

    public void setMaxPersistWritten(int n) {
        this.maxPersistWritten = n;
    }

    public void setEncryptSessionPersistIdRef(int n) {
        this.encryptSessionPersistIdRef = n;
        LittleEndian.putInt(this._header, 4, n == -1 ? 28 : 32);
    }

    protected UserEditAtom(byte[] byArray, int n, int n2) {
        if (n2 < 34) {
            n2 = 34;
        }
        int n3 = n;
        this._header = new byte[8];
        System.arraycopy(byArray, n3, this._header, 0, 8);
        this.lastViewedSlideID = LittleEndian.getInt(byArray, n3 += 8);
        this.pptVersion = LittleEndian.getInt(byArray, n3 += 4);
        this.lastUserEditAtomOffset = LittleEndian.getInt(byArray, n3 += 4);
        this.persistPointersOffset = LittleEndian.getInt(byArray, n3 += 4);
        this.docPersistRef = LittleEndian.getInt(byArray, n3 += 4);
        this.maxPersistWritten = LittleEndian.getInt(byArray, n3 += 4);
        this.lastViewType = LittleEndian.getShort(byArray, n3 += 4);
        this.unused = LittleEndian.getShort(byArray, n3 += 2);
        if ((n3 += 2) - n < n2) {
            this.encryptSessionPersistIdRef = LittleEndian.getInt(byArray, n3);
            n3 += 4;
        }
        assert (n3 - n == n2);
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> hashtable) {
        Integer n;
        if (this.lastUserEditAtomOffset != 0) {
            n = hashtable.get(this.lastUserEditAtomOffset);
            if (n == null) {
                throw new RuntimeException("Couldn't find the new location of the UserEditAtom that used to be at " + this.lastUserEditAtomOffset);
            }
            this.lastUserEditAtomOffset = n;
        }
        if ((n = hashtable.get(this.persistPointersOffset)) == null) {
            throw new RuntimeException("Couldn't find the new location of the PersistPtr that used to be at " + this.persistPointersOffset);
        }
        this.persistPointersOffset = n;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        UserEditAtom.writeLittleEndian(this.lastViewedSlideID, outputStream);
        UserEditAtom.writeLittleEndian(this.pptVersion, outputStream);
        UserEditAtom.writeLittleEndian(this.lastUserEditAtomOffset, outputStream);
        UserEditAtom.writeLittleEndian(this.persistPointersOffset, outputStream);
        UserEditAtom.writeLittleEndian(this.docPersistRef, outputStream);
        UserEditAtom.writeLittleEndian(this.maxPersistWritten, outputStream);
        UserEditAtom.writeLittleEndian(this.lastViewType, outputStream);
        UserEditAtom.writeLittleEndian(this.unused, outputStream);
        if (this.encryptSessionPersistIdRef != -1) {
            UserEditAtom.writeLittleEndian(this.encryptSessionPersistIdRef, outputStream);
        }
    }
}

