/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.TextSpecInfoRun;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class TextSpecInfoAtom
extends RecordAtom {
    private static final long _type = RecordTypes.TextSpecInfoAtom.typeID;
    private byte[] _header = new byte[8];
    private byte[] _data;

    public TextSpecInfoAtom() {
        LittleEndian.putUInt(this._header, 4, _type);
        this.reset(1);
    }

    public TextSpecInfoAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    public void setTextSize(int n) {
        LittleEndian.putInt(this._data, 0, n);
    }

    public void reset(int n) {
        TextSpecInfoRun textSpecInfoRun = new TextSpecInfoRun(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            textSpecInfoRun.writeOut(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this._data = byteArrayOutputStream.toByteArray();
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    public void setParentSize(int n) {
        TextSpecInfoRun textSpecInfoRun;
        assert (n > 0);
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TextSpecInfoRun[] textSpecInfoRunArray = this.getTextSpecInfoRuns();
        assert (textSpecInfoRunArray.length > 0);
        for (int i = 0; i < textSpecInfoRunArray.length && n2 < n; n2 += textSpecInfoRun.getLength(), ++i) {
            textSpecInfoRun = textSpecInfoRunArray[i];
            if (n2 + textSpecInfoRun.getLength() > n || i == textSpecInfoRunArray.length - 1) {
                textSpecInfoRun.setLength(n - n2);
            }
            try {
                textSpecInfoRun.writeOut(byteArrayOutputStream);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this._data = byteArrayOutputStream.toByteArray();
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    public int getCharactersCovered() {
        int n = 0;
        for (TextSpecInfoRun textSpecInfoRun : this.getTextSpecInfoRuns()) {
            n += textSpecInfoRun.length;
        }
        return n;
    }

    public TextSpecInfoRun[] getTextSpecInfoRuns() {
        LittleEndianByteArrayInputStream littleEndianByteArrayInputStream = new LittleEndianByteArrayInputStream(this._data);
        ArrayList<TextSpecInfoRun> arrayList = new ArrayList<TextSpecInfoRun>();
        while (littleEndianByteArrayInputStream.available() > 0) {
            arrayList.add(new TextSpecInfoRun(littleEndianByteArrayInputStream));
        }
        return arrayList.toArray(new TextSpecInfoRun[arrayList.size()]);
    }
}

