/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class TextRulerAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _data;
    private int defaultTabSize;
    private int numLevels;
    private int[] tabStops;
    private int[] bulletOffsets = new int[5];
    private int[] textOffsets = new int[5];

    public TextRulerAtom() {
        this._header = new byte[8];
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected TextRulerAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
        try {
            this.read();
        }
        catch (Exception exception) {
            logger.log(7, new Object[]{"Failed to parse TextRulerAtom: " + exception.getMessage()});
            exception.printStackTrace();
        }
    }

    public long getRecordType() {
        return RecordTypes.TextRulerAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    private void read() {
        int n = 0;
        short s = LittleEndian.getShort(this._data);
        n += 4;
        int[] nArray = new int[]{1, 0, 2, 3, 8, 4, 9, 5, 10, 6, 11, 7, 12};
        block7: for (int i = 0; i < nArray.length; ++i) {
            if ((s & 1 << nArray[i]) == 0) continue;
            switch (nArray[i]) {
                case 0: {
                    this.defaultTabSize = LittleEndian.getShort(this._data, n);
                    n += 2;
                    continue block7;
                }
                case 1: {
                    this.numLevels = LittleEndian.getShort(this._data, n);
                    n += 2;
                    continue block7;
                }
                case 2: {
                    short s2 = LittleEndian.getShort(this._data, n);
                    n += 2;
                    this.tabStops = new int[s2 * 2];
                    for (int j = 0; j < this.tabStops.length; ++j) {
                        this.tabStops[j] = LittleEndian.getUShort(this._data, n);
                        n += 2;
                    }
                    continue block7;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    short s2 = LittleEndian.getShort(this._data, n);
                    n += 2;
                    this.bulletOffsets[nArray[i] - 3] = s2;
                    continue block7;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    short s2 = LittleEndian.getShort(this._data, n);
                    n += 2;
                    this.textOffsets[nArray[i] - 8] = s2;
                }
            }
        }
    }

    public int getDefaultTabSize() {
        return this.defaultTabSize;
    }

    public int getNumberOfLevels() {
        return this.numLevels;
    }

    public int[] getTabStops() {
        return this.tabStops;
    }

    public int[] getTextOffsets() {
        return this.textOffsets;
    }

    public int[] getBulletOffsets() {
        return this.bulletOffsets;
    }

    public static TextRulerAtom getParagraphInstance() {
        byte[] byArray = new byte[]{0, 0, -90, 15, 10, 0, 0, 0, 16, 3, 0, 0, -7, 0, 65, 1, 65, 1};
        TextRulerAtom textRulerAtom = new TextRulerAtom(byArray, 0, byArray.length);
        return textRulerAtom;
    }

    public void setParagraphIndent(short s, short s2) {
        LittleEndian.putShort(this._data, 4, s);
        LittleEndian.putShort(this._data, 6, s2);
        LittleEndian.putShort(this._data, 8, s2);
    }
}

