/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ParentAwareRecord;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class TextHeaderAtom
extends RecordAtom
implements ParentAwareRecord {
    private byte[] _header;
    private static long _type = RecordTypes.TextHeaderAtom.typeID;
    private RecordContainer parentRecord;
    public static final int TITLE_TYPE = 0;
    public static final int BODY_TYPE = 1;
    public static final int NOTES_TYPE = 2;
    public static final int OTHER_TYPE = 4;
    public static final int CENTRE_BODY_TYPE = 5;
    public static final int CENTER_TITLE_TYPE = 6;
    public static final int HALF_BODY_TYPE = 7;
    public static final int QUARTER_BODY_TYPE = 8;
    private int textType;
    private int index = -1;

    public int getTextType() {
        return this.textType;
    }

    public void setTextType(int n) {
        this.textType = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public RecordContainer getParentRecord() {
        return this.parentRecord;
    }

    public void setParentRecord(RecordContainer recordContainer) {
        this.parentRecord = recordContainer;
    }

    protected TextHeaderAtom(byte[] byArray, int n, int n2) {
        if (n2 < 12) {
            n2 = 12;
            if (byArray.length - n < 12) {
                throw new RuntimeException("Not enough data to form a TextHeaderAtom (always 12 bytes long) - found " + (byArray.length - n));
            }
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.textType = LittleEndian.getInt(byArray, n + 8);
    }

    public TextHeaderAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 4);
        this.textType = 4;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        TextHeaderAtom.writeLittleEndian(this.textType, outputStream);
    }
}

