/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;

public final class TextBytesAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = RecordTypes.TextBytesAtom.typeID;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromCompressedUnicode(this._text, 0, this._text.length);
    }

    public void setText(byte[] byArray) {
        this._text = byArray;
        LittleEndian.putInt(this._header, 4, this._text.length);
    }

    protected TextBytesAtom(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._text = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._text, 0, n2 - 8);
    }

    public TextBytesAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 0);
        this._text = new byte[0];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._text);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TextBytesAtom:\n");
        stringBuffer.append(HexDump.dump(this._text, 0L, 0));
        return stringBuffer.toString();
    }
}

