/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyleTextPropAtom
extends RecordAtom {
    private byte[] _header;
    private static final long _type = RecordTypes.StyleTextPropAtom.typeID;
    private byte[] reserved;
    private byte[] rawContents;
    private boolean initialised = false;
    private List<TextPropCollection> paragraphStyles;
    private List<TextPropCollection> charStyles;

    public List<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public void setParagraphStyles(List<TextPropCollection> list) {
        this.paragraphStyles = list;
    }

    public List<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public void setCharacterStyles(List<TextPropCollection> list) {
        this.charStyles = list;
    }

    public int getParagraphTextLengthCovered() {
        return this.getCharactersCovered(this.paragraphStyles);
    }

    public int getCharacterTextLengthCovered() {
        return this.getCharactersCovered(this.charStyles);
    }

    private int getCharactersCovered(List<TextPropCollection> list) {
        int n = 0;
        for (TextPropCollection textPropCollection : list) {
            n += textPropCollection.getCharactersCovered();
        }
        return n;
    }

    public StyleTextPropAtom(byte[] byArray, int n, int n2) {
        if (n2 < 18) {
            n2 = 18;
            if (byArray.length - n < 18) {
                throw new RuntimeException("Not enough data to form a StyleTextPropAtom (min size 18 bytes long) - found " + (byArray.length - n));
            }
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.rawContents = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this.rawContents, 0, this.rawContents.length);
        this.reserved = new byte[0];
        this.paragraphStyles = new ArrayList<TextPropCollection>();
        this.charStyles = new ArrayList<TextPropCollection>();
    }

    public StyleTextPropAtom(int n) {
        this._header = new byte[8];
        this.rawContents = new byte[0];
        this.reserved = new byte[0];
        LittleEndian.putInt(this._header, 2, (short)_type);
        LittleEndian.putInt(this._header, 4, 10);
        this.paragraphStyles = new ArrayList<TextPropCollection>();
        this.charStyles = new ArrayList<TextPropCollection>();
        this.addParagraphTextPropCollection(n);
        this.addCharacterTextPropCollection(n);
        this.initialised = true;
        try {
            this.updateRawContents();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        this.updateRawContents();
        outputStream.write(this._header);
        outputStream.write(this.rawContents);
        outputStream.write(this.reserved);
    }

    public void setParentTextSize(int n) {
        int n2;
        TextPropCollection textPropCollection;
        int n3;
        int n4;
        if (this.initialised) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        this.paragraphStyles.clear();
        this.charStyles.clear();
        int n7 = n;
        while (n5 < this.rawContents.length && n6 < n7) {
            n4 = LittleEndian.getInt(this.rawContents, n5);
            n4 = this.checkTextLength(n4, n6, n);
            n6 += n4;
            short s = LittleEndian.getShort(this.rawContents, n5 += 4);
            n3 = LittleEndian.getInt(this.rawContents, n5 += 2);
            textPropCollection = new TextPropCollection(n4, TextPropCollection.TextPropType.paragraph);
            textPropCollection.setIndentLevel(s);
            n2 = textPropCollection.buildTextPropList(n3, this.rawContents, n5 += 4);
            this.paragraphStyles.add(textPropCollection);
            if ((n5 += n2) >= this.rawContents.length || n6 != n) continue;
            ++n7;
        }
        if (this.rawContents.length > 0 && n6 != n + 1) {
            logger.log(5, new Object[]{"Problem reading paragraph style runs: textHandled = " + n6 + ", text.size+1 = " + (n + 1)});
        }
        n6 = 0;
        n4 = n;
        while (n5 < this.rawContents.length && n6 < n4) {
            int n8 = LittleEndian.getInt(this.rawContents, n5);
            n8 = this.checkTextLength(n8, n6, n);
            n6 += n8;
            n3 = LittleEndian.getInt(this.rawContents, n5 += 4);
            textPropCollection = new TextPropCollection(n8, TextPropCollection.TextPropType.character);
            n2 = textPropCollection.buildTextPropList(n3, this.rawContents, n5 += 4);
            this.charStyles.add(textPropCollection);
            if ((n5 += n2) >= this.rawContents.length || n6 != n) continue;
            ++n4;
        }
        if (this.rawContents.length > 0 && n6 != n + 1) {
            logger.log(5, new Object[]{"Problem reading character style runs: textHandled = " + n6 + ", text.size+1 = " + (n + 1)});
        }
        if (n5 < this.rawContents.length) {
            this.reserved = new byte[this.rawContents.length - n5];
            System.arraycopy(this.rawContents, n5, this.reserved, 0, this.reserved.length);
        }
        this.initialised = true;
    }

    private int checkTextLength(int n, int n2, int n3) {
        if (n + n2 > n3 + 1) {
            logger.log(5, new Object[]{"Style length of " + n + " at " + n2 + " larger than stated size of " + n3 + ", truncating"});
            return n3 + 1 - n2;
        }
        return n;
    }

    private void updateRawContents() throws IOException {
        if (this.initialised) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (TextPropCollection textPropCollection : this.paragraphStyles) {
                textPropCollection.writeOut(byteArrayOutputStream);
            }
            for (TextPropCollection textPropCollection : this.charStyles) {
                textPropCollection.writeOut(byteArrayOutputStream);
            }
            this.rawContents = byteArrayOutputStream.toByteArray();
        }
        int n = this.rawContents.length + this.reserved.length;
        LittleEndian.putInt(this._header, 4, n);
    }

    public void clearStyles() {
        this.paragraphStyles.clear();
        this.charStyles.clear();
        this.reserved = new byte[0];
        this.initialised = true;
    }

    public TextPropCollection addParagraphTextPropCollection(int n) {
        TextPropCollection textPropCollection = new TextPropCollection(n, TextPropCollection.TextPropType.paragraph);
        this.paragraphStyles.add(textPropCollection);
        return textPropCollection;
    }

    public TextPropCollection addCharacterTextPropCollection(int n) {
        TextPropCollection textPropCollection = new TextPropCollection(n, TextPropCollection.TextPropType.character);
        this.charStyles.add(textPropCollection);
        return textPropCollection;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StyleTextPropAtom:\n");
        if (!this.initialised) {
            stringBuffer.append("Uninitialised, dumping Raw Style Data\n");
        } else {
            stringBuffer.append("Paragraph properties\n");
            for (TextPropCollection textPropCollection : this.getParagraphStyles()) {
                stringBuffer.append(textPropCollection);
            }
            stringBuffer.append("Character properties\n");
            for (TextPropCollection textPropCollection : this.getCharacterStyles()) {
                stringBuffer.append(textPropCollection);
            }
            stringBuffer.append("Reserved bytes\n");
            stringBuffer.append(HexDump.dump(this.reserved, 0L, 0));
        }
        stringBuffer.append("  original byte stream \n");
        Iterator<TextPropCollection> iterator = (Iterator<TextPropCollection>)new byte[this.rawContents.length + this.reserved.length];
        System.arraycopy(this.rawContents, 0, iterator, 0, this.rawContents.length);
        System.arraycopy(this.reserved, 0, iterator, this.rawContents.length, this.reserved.length);
        stringBuffer.append(HexDump.dump(iterator, 0L, 0));
        return stringBuffer.toString();
    }
}

