/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.model.textproperties.TextPFException9;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public final class StyleTextProp9Atom
extends RecordAtom {
    private final TextPFException9[] autoNumberSchemes;
    private byte[] header;
    private byte[] data;
    private short version;
    private short recordId;
    private int length;

    protected StyleTextProp9Atom(byte[] byArray, int n, int n2) {
        LinkedList<TextPFException9> linkedList = new LinkedList<TextPFException9>();
        this.header = new byte[8];
        System.arraycopy(byArray, n, this.header, 0, 8);
        this.version = LittleEndian.getShort(this.header, 0);
        this.recordId = LittleEndian.getShort(this.header, 2);
        this.length = LittleEndian.getInt(this.header, 4);
        this.data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this.data, 0, n2 - 8);
        int n3 = 0;
        while (n3 < this.data.length) {
            TextPFException9 textPFException9 = new TextPFException9(this.data, n3);
            linkedList.add(textPFException9);
            if ((n3 += textPFException9.getRecordLength()) + 4 >= this.data.length) break;
            int n4 = LittleEndian.getInt(this.data, n3);
            if ((n3 += 4) + 4 >= this.data.length) break;
            int n5 = LittleEndian.getInt(this.data, n3);
            n3 += 4;
            if (0 != (n5 & 0x40)) {
                n3 += 2;
            }
            if (n3 + 4 < this.data.length) continue;
            break;
        }
        this.autoNumberSchemes = linkedList.toArray(new TextPFException9[linkedList.size()]);
    }

    public long getRecordType() {
        return this.recordId;
    }

    public short getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public TextPFException9[] getAutoNumberTypes() {
        return this.autoNumberSchemes;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this.header);
        outputStream.write(this.data);
    }

    public void setTextSize(int n) {
        LittleEndian.putInt(this.data, 0, n);
    }

    public void reset(int n) {
        this.data = new byte[10];
        LittleEndian.putInt(this.data, 0, n);
        LittleEndian.putInt(this.data, 4, 1);
        LittleEndian.putShort(this.data, 8, (short)0);
        LittleEndian.putInt(this.header, 4, this.data.length);
    }
}

