/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ParentAwareRecord;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.util.MutableByteArrayOutputStream;
import ai2.org.apache.poi.util.ArrayUtil;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class RecordContainer
extends Record {
    protected Record[] _children;
    private Boolean changingChildRecordsLock = Boolean.TRUE;

    public Record[] getChildRecords() {
        return this._children;
    }

    public boolean isAnAtom() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findChildLocation(Record record) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            for (int i = 0; i < this._children.length; ++i) {
                if (!this._children[i].equals(record)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendChild(Record record) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            Record[] recordArray = new Record[this._children.length + 1];
            System.arraycopy(this._children, 0, recordArray, 0, this._children.length);
            recordArray[this._children.length] = record;
            this._children = recordArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildAt(Record record, int n) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(record);
            this.moveChildRecords(this._children.length - 1, n, 1);
        }
    }

    private void moveChildRecords(int n, int n2, int n3) {
        if (n == n2) {
            return;
        }
        if (n3 == 0) {
            return;
        }
        if (n + n3 > this._children.length) {
            throw new IllegalArgumentException("Asked to move more records than there are!");
        }
        ArrayUtil.arrayMoveWithin(this._children, n, n2, n3);
    }

    public Record findFirstOfType(long l) {
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i].getRecordType() != l) continue;
            return this._children[i];
        }
        return null;
    }

    public Record removeChild(Record record) {
        Record record2 = null;
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (Record record3 : this._children) {
            if (record3 != record) {
                arrayList.add(record3);
                continue;
            }
            record2 = record3;
        }
        this._children = arrayList.toArray(new Record[arrayList.size()]);
        return record2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChildRecord(Record record) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildAfter(Record record, Record record2) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int n = this.findChildLocation(record2);
            if (n == -1) {
                throw new IllegalArgumentException("Asked to add a new child after another record, but that record wasn't one of our children!");
            }
            this.addChildAt(record, n + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildBefore(Record record, Record record2) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int n = this.findChildLocation(record2);
            if (n == -1) {
                throw new IllegalArgumentException("Asked to add a new child before another record, but that record wasn't one of our children!");
            }
            this.addChildAt(record, n);
        }
    }

    public void moveChildBefore(Record record, Record record2) {
        this.moveChildrenBefore(record, 1, record2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenBefore(Record record, int n, Record record2) {
        if (n < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int n2 = this.findChildLocation(record2);
            if (n2 == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            int n3 = this.findChildLocation(record);
            if (n3 == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(n3, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenAfter(Record record, int n, Record record2) {
        if (n < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int n2 = this.findChildLocation(record2);
            if (n2 == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            ++n2;
            int n3 = this.findChildLocation(record);
            if (n3 == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(n3, n2, n);
        }
    }

    public void setChildRecord(Record[] recordArray) {
        this._children = recordArray;
    }

    public void writeOut(byte by, byte by2, long l, Record[] recordArray, OutputStream outputStream) throws IOException {
        if (outputStream instanceof MutableByteArrayOutputStream) {
            int n;
            MutableByteArrayOutputStream mutableByteArrayOutputStream = (MutableByteArrayOutputStream)outputStream;
            int n2 = mutableByteArrayOutputStream.getBytesWritten();
            mutableByteArrayOutputStream.write(new byte[]{by, by2});
            byte[] byArray = new byte[2];
            LittleEndian.putShort(byArray, 0, (short)l);
            mutableByteArrayOutputStream.write(byArray);
            mutableByteArrayOutputStream.write(new byte[4]);
            for (n = 0; n < recordArray.length; ++n) {
                recordArray[n].writeOut(mutableByteArrayOutputStream);
            }
            n = mutableByteArrayOutputStream.getBytesWritten() - n2 - 8;
            byte[] byArray2 = new byte[4];
            LittleEndian.putInt(byArray2, 0, n);
            mutableByteArrayOutputStream.overwrite(byArray2, n2 + 4);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new byte[]{by, by2});
            byte[] byArray = new byte[2];
            LittleEndian.putShort(byArray, 0, (short)l);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            for (int i = 0; i < recordArray.length; ++i) {
                recordArray[i].writeOut(byteArrayOutputStream);
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            LittleEndian.putInt(byArray3, 4, byArray3.length - 8);
            outputStream.write(byArray3);
        }
    }

    public static void handleParentAwareRecords(RecordContainer recordContainer) {
        for (Record record : recordContainer.getChildRecords()) {
            if (record instanceof ParentAwareRecord) {
                ((ParentAwareRecord)((Object)record)).setParentRecord(recordContainer);
            }
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
    }
}

