/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordAtom;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistPtrHolder
extends PositionDependentRecordAtom {
    private byte[] _header;
    private byte[] _ptrData;
    private long _type;
    private Hashtable<Integer, Integer> _slideLocations;
    private static final BitField persistIdFld = new BitField(1048575);
    private static final BitField cntPersistFld = new BitField(-1048576);

    @Override
    public long getRecordType() {
        return this._type;
    }

    public int[] getKnownSlideIDs() {
        int[] nArray = new int[this._slideLocations.size()];
        int n = 0;
        for (Integer n2 : this._slideLocations.keySet()) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public Hashtable<Integer, Integer> getSlideLocationsLookup() {
        return this._slideLocations;
    }

    @Deprecated
    public Hashtable<Integer, Integer> getSlideOffsetDataLocationsLookup() {
        throw new UnsupportedOperationException("PersistPtrHolder.getSlideOffsetDataLocationsLookup() is not supported since 3.12-Beta1");
    }

    protected PersistPtrHolder(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        this._slideLocations = new Hashtable();
        this._ptrData = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._ptrData, 0, this._ptrData.length);
        int n3 = 0;
        while (n3 < this._ptrData.length) {
            int n4 = LittleEndian.getInt(this._ptrData, n3);
            int n5 = persistIdFld.getValue(n4);
            int n6 = cntPersistFld.getValue(n4);
            n3 += 4;
            for (int i = 0; i < n6; ++i) {
                int n7 = n5 + i;
                int n8 = (int)LittleEndian.getUInt(this._ptrData, n3);
                this._slideLocations.put(n7, n8);
                n3 += 4;
            }
        }
    }

    public void clear() {
        this._slideLocations.clear();
    }

    public void addSlideLookup(int n, int n2) {
        if (this._slideLocations.containsKey(n)) {
            throw new CorruptPowerPointFileException("A record with persistId " + n + " already exists.");
        }
        this._slideLocations.put(n, n2);
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> hashtable) {
        for (Map.Entry<Integer, Integer> entry : this._slideLocations.entrySet()) {
            Integer n = entry.getValue();
            Integer n2 = hashtable.get(n);
            if (n2 == null) {
                Integer n3 = entry.getKey();
                logger.log(5, new Object[]{"Couldn't find the new location of the \"slide\" with id " + n3 + " that used to be at " + n});
                logger.log(5, new Object[]{"Not updating the position of it, you probably won't be able to find it any more (if you ever could!)"});
                continue;
            }
            entry.setValue(n2);
        }
    }

    private void normalizePersistDirectory() {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(this._slideLocations);
        BufAccessBAOS bufAccessBAOS = new BufAccessBAOS();
        byte[] byArray = new byte[4];
        int n = -1;
        int n2 = -1;
        for (Map.Entry<Integer, Integer> entry : treeMap.entrySet()) {
            int n3 = entry.getKey();
            int n4 = entry.getValue();
            try {
                int n5;
                if (n2 + 1 == n3) {
                    assert (n != -1);
                    n5 = LittleEndian.getInt(bufAccessBAOS.getBuf(), n);
                    int n6 = cntPersistFld.getValue(n5);
                    n5 = cntPersistFld.setValue(n5, n6 + 1);
                    LittleEndian.putInt(bufAccessBAOS.getBuf(), n, n5);
                } else {
                    n = bufAccessBAOS.size();
                    n5 = persistIdFld.setValue(0, n3);
                    n5 = cntPersistFld.setValue(n5, 1);
                    LittleEndian.putInt(byArray, 0, n5);
                    bufAccessBAOS.write(byArray);
                }
                LittleEndian.putInt(byArray, 0, n4);
                bufAccessBAOS.write(byArray);
                n2 = n3;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this._ptrData = bufAccessBAOS.toByteArray();
        LittleEndian.putInt(this._header, 4, bufAccessBAOS.size());
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        this.normalizePersistDirectory();
        outputStream.write(this._header);
        outputStream.write(this._ptrData);
    }

    private static class BufAccessBAOS
    extends ByteArrayOutputStream {
        private BufAccessBAOS() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

