/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class OEShapeAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _recdata;

    public OEShapeAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    protected OEShapeAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._recdata = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._recdata, 0, n2 - 8);
    }

    public long getRecordType() {
        return RecordTypes.OEShapeAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._recdata);
    }

    public int getOptions() {
        return LittleEndian.getInt(this._recdata, 0);
    }

    public void setOptions(int n) {
        LittleEndian.putInt(this._recdata, 0, n);
    }
}

