/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.SheetContainer;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.hslf.record.TxMasterStyleAtom;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class MainMaster
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1016L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;
    private TxMasterStyleAtom[] txmasters;
    private ColorSchemeAtom[] clrscheme;
    private ColorSchemeAtom _colorScheme;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    public TxMasterStyleAtom[] getTxMasterStyleAtoms() {
        return this.txmasters;
    }

    public ColorSchemeAtom[] getColorSchemeAtoms() {
        return this.clrscheme;
    }

    protected MainMaster(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        ArrayList<TxMasterStyleAtom> arrayList = new ArrayList<TxMasterStyleAtom>();
        ArrayList<ColorSchemeAtom> arrayList2 = new ArrayList<ColorSchemeAtom>();
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            } else if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            } else if (this._children[i] instanceof TxMasterStyleAtom) {
                arrayList.add((TxMasterStyleAtom)this._children[i]);
            } else if (this._children[i] instanceof ColorSchemeAtom) {
                arrayList2.add((ColorSchemeAtom)this._children[i]);
            }
            if (this.ppDrawing == null || !(this._children[i] instanceof ColorSchemeAtom)) continue;
            this._colorScheme = (ColorSchemeAtom)this._children[i];
        }
        this.txmasters = arrayList.toArray(new TxMasterStyleAtom[arrayList.size()]);
        this.clrscheme = arrayList2.toArray(new ColorSchemeAtom[arrayList2.size()]);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }

    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }
}

