/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class InteractiveInfoAtom
extends RecordAtom {
    public static final byte ACTION_NONE = 0;
    public static final byte ACTION_MACRO = 1;
    public static final byte ACTION_RUNPROGRAM = 2;
    public static final byte ACTION_JUMP = 3;
    public static final byte ACTION_HYPERLINK = 4;
    public static final byte ACTION_OLE = 5;
    public static final byte ACTION_MEDIA = 6;
    public static final byte ACTION_CUSTOMSHOW = 7;
    public static final byte JUMP_NONE = 0;
    public static final byte JUMP_NEXTSLIDE = 1;
    public static final byte JUMP_PREVIOUSSLIDE = 2;
    public static final byte JUMP_FIRSTSLIDE = 3;
    public static final byte JUMP_LASTSLIDE = 4;
    public static final byte JUMP_LASTSLIDEVIEWED = 5;
    public static final byte JUMP_ENDSHOW = 6;
    public static final byte LINK_NextSlide = 0;
    public static final byte LINK_PreviousSlide = 1;
    public static final byte LINK_FirstSlide = 2;
    public static final byte LINK_LastSlide = 3;
    public static final byte LINK_CustomShow = 6;
    public static final byte LINK_SlideNumber = 7;
    public static final byte LINK_Url = 8;
    public static final byte LINK_OtherPresentation = 9;
    public static final byte LINK_OtherFile = 10;
    public static final byte LINK_NULL = -1;
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected InteractiveInfoAtom() {
        this._data = new byte[16];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected InteractiveInfoAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
        if (this._data.length < 16) {
            throw new IllegalArgumentException("The length of the data for a InteractiveInfoAtom must be at least 16 bytes, but was only " + this._data.length);
        }
    }

    public int getHyperlinkID() {
        return LittleEndian.getInt(this._data, 4);
    }

    public void setHyperlinkID(int n) {
        LittleEndian.putInt(this._data, 4, n);
    }

    public int getSoundRef() {
        return LittleEndian.getInt(this._data, 0);
    }

    public void setSoundRef(int n) {
        LittleEndian.putInt(this._data, 0, n);
    }

    public byte getAction() {
        return this._data[8];
    }

    public void setAction(byte by) {
        this._data[8] = by;
    }

    public byte getOleVerb() {
        return this._data[9];
    }

    public void setOleVerb(byte by) {
        this._data[9] = by;
    }

    public byte getJump() {
        return this._data[10];
    }

    public void setJump(byte by) {
        this._data[10] = by;
    }

    public byte getFlags() {
        return this._data[11];
    }

    public void setFlags(byte by) {
        this._data[11] = by;
    }

    public byte getHyperlinkType() {
        return this._data[12];
    }

    public void setHyperlinkType(byte by) {
        this._data[12] = by;
    }

    public long getRecordType() {
        return RecordTypes.InteractiveInfoAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }
}

