/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.HeadersFootersAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class HeadersFootersContainer
extends RecordContainer {
    public static final short SlideHeadersFootersContainer = 63;
    public static final short NotesHeadersFootersContainer = 79;
    public static final int USERDATEATOM = 0;
    public static final int HEADERATOM = 1;
    public static final int FOOTERATOM = 2;
    private byte[] _header = new byte[8];
    private HeadersFootersAtom hdAtom;
    private CString csDate;
    private CString csHeader;
    private CString csFooter;

    protected HeadersFootersContainer(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof HeadersFootersAtom) {
                this.hdAtom = (HeadersFootersAtom)this._children[i];
                continue;
            }
            if (this._children[i] instanceof CString) {
                CString cString = (CString)this._children[i];
                int n3 = cString.getOptions() >> 4;
                switch (n3) {
                    case 0: {
                        this.csDate = cString;
                        break;
                    }
                    case 1: {
                        this.csHeader = cString;
                        break;
                    }
                    case 2: {
                        this.csFooter = cString;
                        break;
                    }
                    default: {
                        logger.log(5, new Object[]{"Unexpected CString.Options in HeadersFootersContainer: " + n3});
                        break;
                    }
                }
                continue;
            }
            logger.log(5, new Object[]{"Unexpected record in HeadersFootersContainer: " + this._children[i]});
        }
    }

    public HeadersFootersContainer(short s) {
        LittleEndian.putShort(this._header, 0, s);
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this.hdAtom = new HeadersFootersAtom();
        this._children = new Record[]{this.hdAtom};
        this.csFooter = null;
        this.csHeader = null;
        this.csDate = null;
    }

    public long getRecordType() {
        return RecordTypes.HeadersFooters.typeID;
    }

    public int getOptions() {
        return LittleEndian.getShort(this._header, 0);
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }

    public HeadersFootersAtom getHeadersFootersAtom() {
        return this.hdAtom;
    }

    public CString getUserDateAtom() {
        return this.csDate;
    }

    public CString getHeaderAtom() {
        return this.csHeader;
    }

    public CString getFooterAtom() {
        return this.csFooter;
    }

    public CString addUserDateAtom() {
        if (this.csDate != null) {
            return this.csDate;
        }
        this.csDate = new CString();
        this.csDate.setOptions(0);
        this.addChildAfter(this.csDate, this.hdAtom);
        return this.csDate;
    }

    public CString addHeaderAtom() {
        if (this.csHeader != null) {
            return this.csHeader;
        }
        this.csHeader = new CString();
        this.csHeader.setOptions(16);
        HeadersFootersAtom headersFootersAtom = this.hdAtom;
        if (this.csDate != null) {
            headersFootersAtom = this.hdAtom;
        }
        this.addChildAfter(this.csHeader, headersFootersAtom);
        return this.csHeader;
    }

    public CString addFooterAtom() {
        if (this.csFooter != null) {
            return this.csFooter;
        }
        this.csFooter = new CString();
        this.csFooter.setOptions(32);
        RecordAtom recordAtom = this.hdAtom;
        if (this.csHeader != null) {
            recordAtom = this.csHeader;
        } else if (this.csDate != null) {
            recordAtom = this.csDate;
        }
        this.addChildAfter(this.csFooter, recordAtom);
        return this.csFooter;
    }
}

