/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.FontEntityAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class FontCollection
extends RecordContainer {
    private List<String> fonts;
    private byte[] _header = new byte[8];

    protected FontCollection(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.fonts = new ArrayList<String>();
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof FontEntityAtom) {
                FontEntityAtom fontEntityAtom = (FontEntityAtom)this._children[i];
                this.fonts.add(fontEntityAtom.getFontName());
                continue;
            }
            logger.log(5, new Object[]{"Warning: FontCollection child wasn't a FontEntityAtom, was " + this._children[i]});
        }
    }

    public long getRecordType() {
        return RecordTypes.FontCollection.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }

    public int addFont(String string) {
        int n = this.getFontIndex(string);
        if (n != -1) {
            return n;
        }
        return this.addFont(string, 0, 0, 4, 34);
    }

    public int addFont(String string, int n, int n2, int n3, int n4) {
        FontEntityAtom fontEntityAtom = new FontEntityAtom();
        fontEntityAtom.setFontIndex(this.fonts.size() << 4);
        fontEntityAtom.setFontName(string);
        fontEntityAtom.setCharSet(n);
        fontEntityAtom.setFontFlags(n2);
        fontEntityAtom.setFontType(n3);
        fontEntityAtom.setPitchAndFamily(n4);
        this.fonts.add(string);
        this.appendChildRecord(fontEntityAtom);
        return this.fonts.size() - 1;
    }

    public int getFontIndex(String string) {
        for (int i = 0; i < this.fonts.size(); ++i) {
            if (!this.fonts.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfFonts() {
        return this.fonts.size();
    }

    public String getFontWithId(int n) {
        if (n >= this.fonts.size()) {
            return null;
        }
        return this.fonts.get(n);
    }
}

