/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ExHyperlink;
import ai2.org.apache.poi.hslf.record.ExObjListAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExObjList
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1033L;
    private ExObjListAtom exObjListAtom;

    public ExObjListAtom getExObjListAtom() {
        return this.exObjListAtom;
    }

    public ExHyperlink[] getExHyperlinks() {
        ArrayList<ExHyperlink> arrayList = new ArrayList<ExHyperlink>();
        for (int i = 0; i < this._children.length; ++i) {
            if (!(this._children[i] instanceof ExHyperlink)) continue;
            arrayList.add((ExHyperlink)this._children[i]);
        }
        return arrayList.toArray(new ExHyperlink[arrayList.size()]);
    }

    protected ExObjList(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (!(this._children[0] instanceof ExObjListAtom)) {
            throw new IllegalStateException("First child record wasn't a ExObjListAtom, was of type " + this._children[0].getRecordType());
        }
        this.exObjListAtom = (ExObjListAtom)this._children[0];
    }

    public ExObjList() {
        this._children = new Record[1];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        this._children[0] = new ExObjListAtom();
        this.findInterestingChildren();
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }

    public ExHyperlink get(int n) {
        for (int i = 0; i < this._children.length; ++i) {
            ExHyperlink exHyperlink;
            if (!(this._children[i] instanceof ExHyperlink) || (exHyperlink = (ExHyperlink)this._children[i]).getExHyperlinkAtom().getNumber() != n) continue;
            return exHyperlink;
        }
        return null;
    }
}

