/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class ExMediaAtom
extends RecordAtom {
    public static final int fLoop = 1;
    public static final int fRewind = 2;
    public static final int fNarration = 4;
    private byte[] _header;
    private byte[] _recdata;

    protected ExMediaAtom() {
        this._recdata = new byte[8];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    protected ExMediaAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._recdata = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._recdata, 0, n2 - 8);
    }

    public long getRecordType() {
        return RecordTypes.ExMediaAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._recdata);
    }

    public int getObjectId() {
        return LittleEndian.getInt(this._recdata, 0);
    }

    public void setObjectId(int n) {
        LittleEndian.putInt(this._recdata, 0, n);
    }

    public int getMask() {
        return LittleEndian.getInt(this._recdata, 4);
    }

    public void setMask(int n) {
        LittleEndian.putInt(this._recdata, 4, n);
    }

    public boolean getFlag(int n) {
        return (this.getMask() & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        int n2 = this.getMask();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.setMask(n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ExMediaAtom\n");
        stringBuffer.append("\tObjectId: " + this.getObjectId() + "\n");
        stringBuffer.append("\tMask    : " + this.getMask() + "\n");
        stringBuffer.append("\t  fLoop        : " + this.getFlag(1) + "\n");
        stringBuffer.append("\t  fRewind   : " + this.getFlag(2) + "\n");
        stringBuffer.append("\t  fNarration    : " + this.getFlag(4) + "\n");
        return stringBuffer.toString();
    }
}

