/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ExVideoContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class ExMCIMovie
extends RecordContainer {
    private byte[] _header = new byte[8];
    private ExVideoContainer exVideo;

    protected ExMCIMovie(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    public ExMCIMovie() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this.exVideo = new ExVideoContainer();
        this._children = new Record[]{this.exVideo};
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExVideoContainer) {
            this.exVideo = (ExVideoContainer)this._children[0];
        } else {
            logger.log(7, new Object[]{"First child record wasn't a ExVideoContainer, was of type " + this._children[0].getRecordType()});
        }
    }

    public long getRecordType() {
        return RecordTypes.ExMCIMovie.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }

    public ExVideoContainer getExVideo() {
        return this.exVideo;
    }
}

