/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.ExHyperlinkAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class ExHyperlink
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 4055L;
    private ExHyperlinkAtom linkAtom;
    private CString linkDetailsA;
    private CString linkDetailsB;

    public ExHyperlinkAtom getExHyperlinkAtom() {
        return this.linkAtom;
    }

    public String getLinkURL() {
        return this.linkDetailsB == null ? null : this.linkDetailsB.getText();
    }

    public String getLinkTitle() {
        return this.linkDetailsA == null ? null : this.linkDetailsA.getText();
    }

    public void setLinkURL(String string) {
        if (this.linkDetailsB != null) {
            this.linkDetailsB.setText(string);
        }
    }

    public void setLinkURL(String string, int n) {
        if (this.linkDetailsB != null) {
            this.linkDetailsB.setText(string);
            this.linkDetailsB.setOptions(n);
        }
    }

    public void setLinkTitle(String string) {
        if (this.linkDetailsA != null) {
            this.linkDetailsA.setText(string);
        }
    }

    public String _getDetailsA() {
        return this.linkDetailsA == null ? null : this.linkDetailsA.getText();
    }

    public String _getDetailsB() {
        return this.linkDetailsB == null ? null : this.linkDetailsB.getText();
    }

    protected ExHyperlink(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExHyperlinkAtom) {
            this.linkAtom = (ExHyperlinkAtom)this._children[0];
        } else {
            logger.log(7, new Object[]{"First child record wasn't a ExHyperlinkAtom, was of type " + this._children[0].getRecordType()});
        }
        for (int i = 1; i < this._children.length; ++i) {
            if (this._children[i] instanceof CString) {
                if (this.linkDetailsA == null) {
                    this.linkDetailsA = (CString)this._children[i];
                    continue;
                }
                this.linkDetailsB = (CString)this._children[i];
                continue;
            }
            logger.log(7, new Object[]{"Record after ExHyperlinkAtom wasn't a CString, was of type " + this._children[1].getRecordType()});
        }
    }

    public ExHyperlink() {
        this._children = new Record[3];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        CString cString = new CString();
        CString cString2 = new CString();
        cString.setOptions(0);
        cString2.setOptions(16);
        this._children[0] = new ExHyperlinkAtom();
        this._children[1] = cString;
        this._children[2] = cString2;
        this.findInterestingChildren();
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }
}

