/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class ExEmbedAtom
extends RecordAtom {
    public static final int DOES_NOT_FOLLOW_COLOR_SCHEME = 0;
    public static final int FOLLOWS_ENTIRE_COLOR_SCHEME = 1;
    public static final int FOLLOWS_TEXT_AND_BACKGROUND_SCHEME = 2;
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected ExEmbedAtom() {
        this._data = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected ExEmbedAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
        if (this._data.length < 8) {
            throw new IllegalArgumentException("The length of the data for a ExEmbedAtom must be at least 4 bytes, but was only " + this._data.length);
        }
    }

    public int getFollowColorScheme() {
        return LittleEndian.getInt(this._data, 0);
    }

    public boolean getCantLockServerB() {
        return this._data[4] != 0;
    }

    public void setCantLockServerB(boolean bl) {
        this._data[4] = (byte)(bl ? 1 : 0);
    }

    public boolean getNoSizeToServerB() {
        return this._data[5] != 0;
    }

    public boolean getIsTable() {
        return this._data[6] != 0;
    }

    public long getRecordType() {
        return RecordTypes.ExEmbedAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }
}

