/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.ExEmbedAtom;
import ai2.org.apache.poi.hslf.record.ExOleObjAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class ExEmbed
extends RecordContainer {
    private byte[] _header = new byte[8];
    protected RecordAtom embedAtom;
    private ExOleObjAtom oleObjAtom;
    private CString menuName;
    private CString progId;
    private CString clipboardName;

    protected ExEmbed(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    public ExEmbed() {
        this._children = new Record[5];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        CString cString = new CString();
        cString.setOptions(16);
        CString cString2 = new CString();
        cString2.setOptions(32);
        CString cString3 = new CString();
        cString3.setOptions(48);
        this._children[0] = new ExEmbedAtom();
        this._children[1] = new ExOleObjAtom();
        this._children[2] = cString;
        this._children[3] = cString2;
        this._children[4] = cString3;
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExEmbedAtom) {
            this.embedAtom = (ExEmbedAtom)this._children[0];
        } else {
            logger.log(7, new Object[]{"First child record wasn't a ExEmbedAtom, was of type " + this._children[0].getRecordType()});
        }
        if (this._children[1] instanceof ExOleObjAtom) {
            this.oleObjAtom = (ExOleObjAtom)this._children[1];
        } else {
            logger.log(7, new Object[]{"Second child record wasn't a ExOleObjAtom, was of type " + this._children[1].getRecordType()});
        }
        block5: for (int i = 2; i < this._children.length; ++i) {
            if (!(this._children[i] instanceof CString)) continue;
            CString cString = (CString)this._children[i];
            int n = cString.getOptions() >> 4;
            switch (n) {
                case 1: {
                    this.menuName = cString;
                    continue block5;
                }
                case 2: {
                    this.progId = cString;
                    continue block5;
                }
                case 3: {
                    this.clipboardName = cString;
                }
            }
        }
    }

    public ExEmbedAtom getExEmbedAtom() {
        return (ExEmbedAtom)this.embedAtom;
    }

    public ExOleObjAtom getExOleObjAtom() {
        return this.oleObjAtom;
    }

    public String getMenuName() {
        return this.menuName == null ? null : this.menuName.getText();
    }

    public void setMenuName(String string) {
        if (this.menuName != null) {
            this.menuName.setText(string);
        }
    }

    public String getProgId() {
        return this.progId == null ? null : this.progId.getText();
    }

    public void setProgId(String string) {
        if (this.progId != null) {
            this.progId.setText(string);
        }
    }

    public String getClipboardName() {
        return this.clipboardName == null ? null : this.clipboardName.getText();
    }

    public void setClipboardName(String string) {
        if (this.clipboardName != null) {
            this.clipboardName.setText(string);
        }
    }

    public long getRecordType() {
        return RecordTypes.ExEmbed.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }
}

