/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherPlaceholder
extends EscherRecord {
    public static final short RECORD_ID = (short)RecordTypes.OEPlaceholderAtom.typeID;
    public static final String RECORD_DESCRIPTION = "msofbtClientTextboxPlaceholder";
    int position = -1;
    byte placementId = 0;
    byte size = 0;
    short unused = 0;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        this.position = LittleEndian.getInt(byArray, n + 8);
        this.placementId = byArray[n + 12];
        this.size = byArray[n + 13];
        this.unused = LittleEndian.getShort(byArray, n + 14);
        assert (n2 + 8 == 16);
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, 8);
        LittleEndian.putInt(byArray, n + 8, this.position);
        LittleEndian.putByte(byArray, n + 12, this.placementId);
        LittleEndian.putByte(byArray, n + 13, this.size);
        LittleEndian.putShort(byArray, n + 14, this.unused);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public String getRecordName() {
        return "ClientTextboxPlaceholder";
    }
}

