/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class DocumentAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1001L;
    private long slideSizeX;
    private long slideSizeY;
    private long notesSizeX;
    private long notesSizeY;
    private long serverZoomFrom;
    private long serverZoomTo;
    private long notesMasterPersist;
    private long handoutMasterPersist;
    private int firstSlideNum;
    private int slideSizeType;
    private byte saveWithFonts;
    private byte omitTitlePlace;
    private byte rightToLeft;
    private byte showComments;
    private byte[] reserved;

    public long getSlideSizeX() {
        return this.slideSizeX;
    }

    public long getSlideSizeY() {
        return this.slideSizeY;
    }

    public long getNotesSizeX() {
        return this.notesSizeX;
    }

    public long getNotesSizeY() {
        return this.notesSizeY;
    }

    public void setSlideSizeX(long l) {
        this.slideSizeX = l;
    }

    public void setSlideSizeY(long l) {
        this.slideSizeY = l;
    }

    public void setNotesSizeX(long l) {
        this.notesSizeX = l;
    }

    public void setNotesSizeY(long l) {
        this.notesSizeY = l;
    }

    public long getServerZoomFrom() {
        return this.serverZoomFrom;
    }

    public long getServerZoomTo() {
        return this.serverZoomTo;
    }

    public void setServerZoomFrom(long l) {
        this.serverZoomFrom = l;
    }

    public void setServerZoomTo(long l) {
        this.serverZoomTo = l;
    }

    public long getNotesMasterPersist() {
        return this.notesMasterPersist;
    }

    public long getHandoutMasterPersist() {
        return this.handoutMasterPersist;
    }

    public int getFirstSlideNum() {
        return this.firstSlideNum;
    }

    public int getSlideSizeType() {
        return this.slideSizeType;
    }

    public boolean getSaveWithFonts() {
        return this.saveWithFonts != 0;
    }

    public boolean getOmitTitlePlace() {
        return this.omitTitlePlace != 0;
    }

    public boolean getRightToLeft() {
        return this.rightToLeft != 0;
    }

    public boolean getShowComments() {
        return this.showComments != 0;
    }

    protected DocumentAtom(byte[] byArray, int n, int n2) {
        if (n2 < 48) {
            n2 = 48;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.slideSizeX = LittleEndian.getInt(byArray, n + 0 + 8);
        this.slideSizeY = LittleEndian.getInt(byArray, n + 4 + 8);
        this.notesSizeX = LittleEndian.getInt(byArray, n + 8 + 8);
        this.notesSizeY = LittleEndian.getInt(byArray, n + 12 + 8);
        this.serverZoomFrom = LittleEndian.getInt(byArray, n + 16 + 8);
        this.serverZoomTo = LittleEndian.getInt(byArray, n + 20 + 8);
        this.notesMasterPersist = LittleEndian.getInt(byArray, n + 24 + 8);
        this.handoutMasterPersist = LittleEndian.getInt(byArray, n + 28 + 8);
        this.firstSlideNum = LittleEndian.getShort(byArray, n + 32 + 8);
        this.slideSizeType = LittleEndian.getShort(byArray, n + 34 + 8);
        this.saveWithFonts = byArray[n + 36 + 8];
        this.omitTitlePlace = byArray[n + 37 + 8];
        this.rightToLeft = byArray[n + 38 + 8];
        this.showComments = byArray[n + 39 + 8];
        this.reserved = new byte[n2 - 40 - 8];
        System.arraycopy(byArray, n + 48, this.reserved, 0, this.reserved.length);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        DocumentAtom.writeLittleEndian((int)this.slideSizeX, outputStream);
        DocumentAtom.writeLittleEndian((int)this.slideSizeY, outputStream);
        DocumentAtom.writeLittleEndian((int)this.notesSizeX, outputStream);
        DocumentAtom.writeLittleEndian((int)this.notesSizeY, outputStream);
        DocumentAtom.writeLittleEndian((int)this.serverZoomFrom, outputStream);
        DocumentAtom.writeLittleEndian((int)this.serverZoomTo, outputStream);
        DocumentAtom.writeLittleEndian((int)this.notesMasterPersist, outputStream);
        DocumentAtom.writeLittleEndian((int)this.handoutMasterPersist, outputStream);
        DocumentAtom.writeLittleEndian((short)this.firstSlideNum, outputStream);
        DocumentAtom.writeLittleEndian((short)this.slideSizeType, outputStream);
        outputStream.write(this.saveWithFonts);
        outputStream.write(this.omitTitlePlace);
        outputStream.write(this.rightToLeft);
        outputStream.write(this.showComments);
        outputStream.write(this.reserved);
    }

    public static final class SlideSize {
        public static final int ON_SCREEN = 0;
        public static final int LETTER_SIZED_PAPER = 1;
        public static final int A4_SIZED_PAPER = 2;
        public static final int ON_35MM = 3;
        public static final int OVERHEAD = 4;
        public static final int BANNER = 5;
        public static final int CUSTOM = 6;
    }
}

