/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.DocumentAtom;
import ai2.org.apache.poi.hslf.record.Environment;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.PPDrawingGroup;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class Document
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1000L;
    private DocumentAtom documentAtom;
    private Environment environment;
    private PPDrawingGroup ppDrawing;
    private SlideListWithText[] slwts;
    private ExObjList exObjList;

    public DocumentAtom getDocumentAtom() {
        return this.documentAtom;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PPDrawingGroup getPPDrawingGroup() {
        return this.ppDrawing;
    }

    public ExObjList getExObjList() {
        return this.exObjList;
    }

    public SlideListWithText[] getSlideListWithTexts() {
        return this.slwts;
    }

    public SlideListWithText getMasterSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 1) continue;
            return this.slwts[i];
        }
        return null;
    }

    public SlideListWithText getSlideSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 0) continue;
            return this.slwts[i];
        }
        return null;
    }

    public SlideListWithText getNotesSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 2) continue;
            return this.slwts[i];
        }
        return null;
    }

    protected Document(byte[] byArray, int n, int n2) {
        int n3;
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        if (!(this._children[0] instanceof DocumentAtom)) {
            throw new IllegalStateException("The first child of a Document must be a DocumentAtom");
        }
        this.documentAtom = (DocumentAtom)this._children[0];
        int n4 = 0;
        for (n3 = 1; n3 < this._children.length; ++n3) {
            if (this._children[n3] instanceof SlideListWithText) {
                ++n4;
            }
            if (this._children[n3] instanceof Environment) {
                this.environment = (Environment)this._children[n3];
            }
            if (this._children[n3] instanceof PPDrawingGroup) {
                this.ppDrawing = (PPDrawingGroup)this._children[n3];
            }
            if (!(this._children[n3] instanceof ExObjList)) continue;
            this.exObjList = (ExObjList)this._children[n3];
        }
        if (n4 == 0) {
            logger.log(5, new Object[]{"No SlideListWithText's found - there should normally be at least one!"});
        }
        if (n4 > 3) {
            logger.log(5, new Object[]{"Found " + n4 + " SlideListWithTexts - normally there should only be three!"});
        }
        this.slwts = new SlideListWithText[n4];
        n4 = 0;
        for (n3 = 1; n3 < this._children.length; ++n3) {
            if (!(this._children[n3] instanceof SlideListWithText)) continue;
            this.slwts[n4] = (SlideListWithText)this._children[n3];
            ++n4;
        }
    }

    public void addSlideListWithText(SlideListWithText slideListWithText) {
        Record record = this._children[this._children.length - 1];
        if (record.getRecordType() == (long)RecordTypes.RoundTripCustomTableStyles12Atom.typeID) {
            record = this._children[this._children.length - 2];
        }
        if (record.getRecordType() != (long)RecordTypes.EndDocument.typeID) {
            throw new IllegalStateException("The last child record of a Document should be EndDocument, but it was " + record);
        }
        this.addChildBefore(slideListWithText, record);
        int n = this.slwts.length + 1;
        SlideListWithText[] slideListWithTextArray = new SlideListWithText[n];
        System.arraycopy(this.slwts, 0, slideListWithTextArray, 0, this.slwts.length);
        slideListWithTextArray[slideListWithTextArray.length - 1] = slideListWithText;
        this.slwts = slideListWithTextArray;
    }

    public void removeSlideListWithText(SlideListWithText slideListWithText) {
        ArrayList<SlideListWithText> arrayList = new ArrayList<SlideListWithText>();
        for (SlideListWithText slideListWithText2 : this.slwts) {
            if (slideListWithText2 != slideListWithText) {
                arrayList.add(slideListWithText2);
                continue;
            }
            this.removeChild(slideListWithText);
        }
        this.slwts = arrayList.toArray(new SlideListWithText[arrayList.size()]);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }
}

