/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ColorSchemeAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 2032L;
    private int backgroundColourRGB;
    private int textAndLinesColourRGB;
    private int shadowsColourRGB;
    private int titleTextColourRGB;
    private int fillsColourRGB;
    private int accentColourRGB;
    private int accentAndHyperlinkColourRGB;
    private int accentAndFollowingHyperlinkColourRGB;

    public int getBackgroundColourRGB() {
        return this.backgroundColourRGB;
    }

    public void setBackgroundColourRGB(int n) {
        this.backgroundColourRGB = n;
    }

    public int getTextAndLinesColourRGB() {
        return this.textAndLinesColourRGB;
    }

    public void setTextAndLinesColourRGB(int n) {
        this.textAndLinesColourRGB = n;
    }

    public int getShadowsColourRGB() {
        return this.shadowsColourRGB;
    }

    public void setShadowsColourRGB(int n) {
        this.shadowsColourRGB = n;
    }

    public int getTitleTextColourRGB() {
        return this.titleTextColourRGB;
    }

    public void setTitleTextColourRGB(int n) {
        this.titleTextColourRGB = n;
    }

    public int getFillsColourRGB() {
        return this.fillsColourRGB;
    }

    public void setFillsColourRGB(int n) {
        this.fillsColourRGB = n;
    }

    public int getAccentColourRGB() {
        return this.accentColourRGB;
    }

    public void setAccentColourRGB(int n) {
        this.accentColourRGB = n;
    }

    public int getAccentAndHyperlinkColourRGB() {
        return this.accentAndHyperlinkColourRGB;
    }

    public void setAccentAndHyperlinkColourRGB(int n) {
        this.accentAndHyperlinkColourRGB = n;
    }

    public int getAccentAndFollowingHyperlinkColourRGB() {
        return this.accentAndFollowingHyperlinkColourRGB;
    }

    public void setAccentAndFollowingHyperlinkColourRGB(int n) {
        this.accentAndFollowingHyperlinkColourRGB = n;
    }

    protected ColorSchemeAtom(byte[] byArray, int n, int n2) {
        if (n2 < 40) {
            n2 = 40;
            if (byArray.length - n < 40) {
                throw new RuntimeException("Not enough data to form a ColorSchemeAtom (always 40 bytes long) - found " + (byArray.length - n));
            }
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.backgroundColourRGB = LittleEndian.getInt(byArray, n + 8 + 0);
        this.textAndLinesColourRGB = LittleEndian.getInt(byArray, n + 8 + 4);
        this.shadowsColourRGB = LittleEndian.getInt(byArray, n + 8 + 8);
        this.titleTextColourRGB = LittleEndian.getInt(byArray, n + 8 + 12);
        this.fillsColourRGB = LittleEndian.getInt(byArray, n + 8 + 16);
        this.accentColourRGB = LittleEndian.getInt(byArray, n + 8 + 20);
        this.accentAndHyperlinkColourRGB = LittleEndian.getInt(byArray, n + 8 + 24);
        this.accentAndFollowingHyperlinkColourRGB = LittleEndian.getInt(byArray, n + 8 + 28);
    }

    public ColorSchemeAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 16);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 32);
        this.backgroundColourRGB = 0xFFFFFF;
        this.textAndLinesColourRGB = 0;
        this.shadowsColourRGB = 0x808080;
        this.titleTextColourRGB = 0;
        this.fillsColourRGB = 0x99CC00;
        this.accentColourRGB = 0xCC3333;
        this.accentAndHyperlinkColourRGB = 0xFFCCCC;
        this.accentAndFollowingHyperlinkColourRGB = 0xB2B2B2;
    }

    public long getRecordType() {
        return _type;
    }

    public static byte[] splitRGB(int n) {
        byte[] byArray = new byte[3];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ColorSchemeAtom.writeLittleEndian(n, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, 0, 3);
        return byArray;
    }

    public static int joinRGB(byte by, byte by2, byte by3) {
        return ColorSchemeAtom.joinRGB(new byte[]{by, by2, by3});
    }

    public static int joinRGB(byte[] byArray) {
        if (byArray.length != 3) {
            throw new RuntimeException("joinRGB accepts a byte array of 3 values, but got one of " + byArray.length + " values!");
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 3);
        byArray2[3] = 0;
        int n = LittleEndian.getInt(byArray2, 0);
        return n;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        ColorSchemeAtom.writeLittleEndian(this.backgroundColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.textAndLinesColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.shadowsColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.titleTextColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.fillsColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.accentColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.accentAndHyperlinkColourRGB, outputStream);
        ColorSchemeAtom.writeLittleEndian(this.accentAndFollowingHyperlinkColourRGB, outputStream);
    }

    public int getColor(int n) {
        int[] nArray = new int[]{this.backgroundColourRGB, this.textAndLinesColourRGB, this.shadowsColourRGB, this.titleTextColourRGB, this.fillsColourRGB, this.accentColourRGB, this.accentAndHyperlinkColourRGB, this.accentAndFollowingHyperlinkColourRGB};
        return nArray[n];
    }
}

