/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;

public final class CString
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4026L;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromUnicodeLE(this._text);
    }

    public void setText(String string) {
        this._text = new byte[string.length() * 2];
        StringUtil.putUnicodeLE(string, this._text, 0);
        LittleEndian.putInt(this._header, 4, this._text.length);
    }

    public int getOptions() {
        return LittleEndian.getShort(this._header);
    }

    public void setOptions(int n) {
        LittleEndian.putShort(this._header, (short)n);
    }

    protected CString(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._text = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._text, 0, n2 - 8);
    }

    public CString() {
        this._header = new byte[]{0, 0, -70, 15, 0, 0, 0, 0};
        this._text = new byte[0];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._text);
    }

    public String toString() {
        return this.getText();
    }
}

