/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model.textproperties;

import ai2.org.apache.poi.sl.usermodel.AutoNumberingScheme;
import ai2.org.apache.poi.util.LittleEndian;

public class TextPFException9 {
    private final byte mask3;
    private final byte mask4;
    private final Short bulletBlipRef;
    private final Short fBulletHasAutoNumber;
    private final AutoNumberingScheme autoNumberScheme;
    private static final AutoNumberingScheme DEFAULT_AUTONUMBER_SHEME = AutoNumberingScheme.arabicPeriod;
    private final Short autoNumberStartNumber;
    private static final Short DEFAULT_START_NUMBER = 1;
    private final int recordLength;

    public TextPFException9(byte[] byArray, int n) {
        this.mask3 = byArray[n + 2];
        this.mask4 = byArray[n + 3];
        int n2 = 4;
        int n3 = n + 4;
        if (0 == (this.mask3 & 0xFFFFFF80)) {
            this.bulletBlipRef = null;
        } else {
            this.bulletBlipRef = LittleEndian.getShort(byArray, n3);
            n3 += 2;
            n2 = 6;
        }
        if (0 == (this.mask4 & 2)) {
            this.fBulletHasAutoNumber = null;
        } else {
            this.fBulletHasAutoNumber = LittleEndian.getShort(byArray, n3);
            n3 += 2;
            n2 += 2;
        }
        if (0 == (this.mask4 & 1)) {
            this.autoNumberScheme = null;
            this.autoNumberStartNumber = null;
        } else {
            this.autoNumberScheme = AutoNumberingScheme.forNativeID(LittleEndian.getShort(byArray, n3));
            this.autoNumberStartNumber = LittleEndian.getShort(byArray, n3 += 2);
            n3 += 2;
            n2 += 4;
        }
        this.recordLength = n2;
    }

    public Short getBulletBlipRef() {
        return this.bulletBlipRef;
    }

    public Short getfBulletHasAutoNumber() {
        return this.fBulletHasAutoNumber;
    }

    public AutoNumberingScheme getAutoNumberScheme() {
        if (null != this.autoNumberScheme) {
            return this.autoNumberScheme;
        }
        if (null != this.fBulletHasAutoNumber && 1 == this.fBulletHasAutoNumber) {
            return DEFAULT_AUTONUMBER_SHEME;
        }
        return null;
    }

    public Short getAutoNumberStartNumber() {
        if (null != this.autoNumberStartNumber) {
            return this.autoNumberStartNumber;
        }
        if (null != this.fBulletHasAutoNumber && 1 == this.fBulletHasAutoNumber) {
            return DEFAULT_START_NUMBER;
        }
        return null;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Record length: ").append(this.recordLength).append(" bytes\n");
        stringBuilder.append("bulletBlipRef: ").append(this.bulletBlipRef).append("\n");
        stringBuilder.append("fBulletHasAutoNumber: ").append(this.fBulletHasAutoNumber).append("\n");
        stringBuilder.append("autoNumberScheme: ").append((Object)this.autoNumberScheme).append("\n");
        stringBuilder.append("autoNumberStartNumber: ").append(this.autoNumberStartNumber).append("\n");
        return stringBuilder.toString();
    }
}

