/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model.textproperties;

import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

public abstract class BitMaskTextProp
extends TextProp
implements Cloneable {
    protected static final POILogger logger = POILogFactory.getLogger(BitMaskTextProp.class);
    private String[] subPropNames;
    private int[] subPropMasks;
    private boolean[] subPropMatches;

    public String[] getSubPropNames() {
        return this.subPropNames;
    }

    public boolean[] getSubPropMatches() {
        return this.subPropMatches;
    }

    protected BitMaskTextProp(int n, int n2, String string, String ... stringArray) {
        super(n, n2, "bitmask");
        this.subPropNames = stringArray;
        this.propName = string;
        this.subPropMasks = new int[stringArray.length];
        this.subPropMatches = new boolean[stringArray.length];
        int n3 = Integer.lowestOneBit(n2);
        for (int i = 0; i < this.subPropMasks.length; ++i) {
            this.subPropMasks[i] = n3 << i;
        }
    }

    public int getWriteMask() {
        int n = 0;
        int n2 = 0;
        for (int n3 : this.subPropMasks) {
            if (!this.subPropMatches[n2++]) continue;
            n |= n3;
        }
        return n;
    }

    public void setWriteMask(int n) {
        int n2 = 0;
        for (int n3 : this.subPropMasks) {
            this.subPropMatches[n2++] = (n & n3) != 0;
        }
    }

    public int getValue() {
        int n = this.dataValue;
        int n2 = 0;
        for (int n3 : this.subPropMasks) {
            if (this.subPropMatches[n2++]) continue;
            n &= ~n3;
        }
        return n;
    }

    public void setValue(int n) {
        this.dataValue = n;
        int n2 = 0;
        for (int n3 : this.subPropMasks) {
            this.subPropMatches[n2++] = (n & n3) != 0;
        }
    }

    public void setValueWithMask(int n, int n2) {
        this.setWriteMask(n2);
        this.dataValue = n;
        this.dataValue = this.getValue();
        if (n != this.dataValue) {
            logger.log(5, new Object[]{"Style properties of '" + this.getName() + "' don't match mask - output will be sanitized"});
            if (logger.check(1)) {
                StringBuilder stringBuilder = new StringBuilder("The following style attributes of the '" + this.getName() + "' property will be ignored:\n");
                int n3 = 0;
                for (int n4 : this.subPropMasks) {
                    if (!this.subPropMatches[n3] && (n & n4) != 0) {
                        stringBuilder.append(this.subPropNames[n3] + ",");
                    }
                    ++n3;
                }
                logger.log(1, new Object[]{stringBuilder.toString()});
            }
        }
    }

    public boolean getSubValue(int n) {
        return this.subPropMatches[n] && (this.dataValue & this.subPropMasks[n]) != 0;
    }

    public void setSubValue(boolean bl, int n) {
        this.subPropMatches[n] = true;
        this.dataValue = bl ? (this.dataValue |= this.subPropMasks[n]) : (this.dataValue &= ~this.subPropMasks[n]);
    }

    public BitMaskTextProp clone() {
        BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)super.clone();
        bitMaskTextProp.subPropMatches = new boolean[this.subPropMatches.length];
        return bitMaskTextProp;
    }

    public BitMaskTextProp cloneAll() {
        return (BitMaskTextProp)super.clone();
    }
}

