/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherArrayProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Polygon
extends HSLFAutoShape {
    protected Polygon(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public Polygon(ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super((EscherContainerRecord)null, shapeContainer);
        this._escherContainer = this.createSpContainer(ShapeType.NOT_PRIMITIVE, shapeContainer instanceof HSLFGroupShape);
    }

    public Polygon() {
        this((ShapeContainer<HSLFShape, HSLFTextParagraph>)null);
    }

    public void setPoints(float[] fArray, float[] fArray2) {
        Object object;
        float f = this.findBiggest(fArray);
        float f2 = this.findBiggest(fArray2);
        float f3 = this.findSmallest(fArray);
        float f4 = this.findSmallest(fArray2);
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        abstractEscherOptRecord.addEscherProperty(new EscherSimpleProperty(322, Units.pointsToMaster(f - f3)));
        abstractEscherOptRecord.addEscherProperty(new EscherSimpleProperty(323, Units.pointsToMaster(f2 - f4)));
        int n = 0;
        while (n < fArray.length) {
            int n2 = n;
            fArray[n2] = fArray[n2] + -f3;
            int n3 = n++;
            fArray2[n3] = fArray2[n3] + -f4;
        }
        n = fArray.length;
        EscherArrayProperty escherArrayProperty = new EscherArrayProperty(325, false, new byte[0]);
        escherArrayProperty.setNumberOfElementsInArray(n + 1);
        escherArrayProperty.setNumberOfElementsInMemory(n + 1);
        escherArrayProperty.setSizeOfElements(65520);
        for (int i = 0; i < n; ++i) {
            object = new byte[4];
            LittleEndian.putShort((byte[])object, 0, (short)Units.pointsToMaster(fArray[i]));
            LittleEndian.putShort((byte[])object, 2, (short)Units.pointsToMaster(fArray2[i]));
            escherArrayProperty.setElement(i, (byte[])object);
        }
        byte[] byArray = new byte[4];
        LittleEndian.putShort(byArray, 0, (short)Units.pointsToMaster(fArray[0]));
        LittleEndian.putShort(byArray, 2, (short)Units.pointsToMaster(fArray2[0]));
        escherArrayProperty.setElement(n, byArray);
        abstractEscherOptRecord.addEscherProperty(escherArrayProperty);
        object = new EscherArrayProperty(326, false, null);
        ((EscherArrayProperty)object).setSizeOfElements(2);
        ((EscherArrayProperty)object).setNumberOfElementsInArray(n * 2 + 4);
        ((EscherArrayProperty)object).setNumberOfElementsInMemory(n * 2 + 4);
        ((EscherArrayProperty)object).setElement(0, new byte[]{0, 64});
        ((EscherArrayProperty)object).setElement(1, new byte[]{0, -84});
        for (int i = 0; i < n; ++i) {
            ((EscherArrayProperty)object).setElement(2 + i * 2, new byte[]{1, 0});
            ((EscherArrayProperty)object).setElement(3 + i * 2, new byte[]{0, -84});
        }
        ((EscherArrayProperty)object).setElement(((EscherArrayProperty)object).getNumberOfElementsInArray() - 2, new byte[]{1, 96});
        ((EscherArrayProperty)object).setElement(((EscherArrayProperty)object).getNumberOfElementsInArray() - 1, new byte[]{0, -128});
        abstractEscherOptRecord.addEscherProperty((EscherProperty)object);
        abstractEscherOptRecord.sortProperties();
    }

    public void setPoints(Point2D[] point2DArray) {
        float[] fArray = new float[point2DArray.length];
        float[] fArray2 = new float[point2DArray.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            fArray[i] = (float)point2DArray[i].getX();
            fArray2[i] = (float)point2DArray[i].getY();
        }
        this.setPoints(fArray, fArray2);
    }

    private float findBiggest(float[] fArray) {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
        }
        return f;
    }

    private float findSmallest(float[] fArray) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
        }
        return f;
    }
}

